/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.bukkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class ReplaceableTagEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private dPlayer player;
    private dNPC npc;
    private boolean instant = false;
    private boolean wasReplaced = false;
    private String baseContext = null;
    private String name = null;
    private String nameContext = null;
    private String type = null;
    private String typeContext = null;
    private String subType = null;
    private String subTypeContext = null;
    private String specifier = null;
    private String specifierContext = null;
    private String value = null;
    private String valueContext = null;
    private String alternative = null;
    private String replaced = null;
    private ScriptEntry scriptEntry = null;
    Pattern basecontextRegex = Pattern.compile("^( )?\\[.*?\\]");
    Pattern alternativeRegex = Pattern.compile("\\|\\|.*");
    Pattern bracketRegex = Pattern.compile("\\[.*?\\]");
    Pattern valueRegex = Pattern.compile(":[^\\]]+(\\[([^\\[])+)?$");
    Pattern componentRegex = Pattern.compile("[^\\[\\]\\.]+(\\[.*?\\])?(\\.)?");
    public String raw_tag;

    public ReplaceableTagEvent(dPlayer player, dNPC npc, String tag) {
        this(player, npc, tag, null);
    }

    public ReplaceableTagEvent(dPlayer player, dNPC npc, String tag, ScriptEntry scriptEntry) {
        Matcher alternativeMatcher;
        this.scriptEntry = scriptEntry;
        this.player = player;
        this.replaced = tag;
        this.npc = npc;
        if (tag.startsWith("!") || tag.startsWith("^")) {
            this.instant = true;
            tag = tag.substring(1);
        }
        if ((alternativeMatcher = this.alternativeRegex.matcher(tag)).find()) {
            tag = tag.substring(0, alternativeMatcher.start()).trim();
            this.alternative = alternativeMatcher.group().substring(2).trim();
        }
        this.raw_tag = tag;
        Matcher bracketMatcher = null;
        Matcher valueMatcher = this.valueRegex.matcher(tag);
        if (valueMatcher.find()) {
            tag = tag.substring(0, valueMatcher.start());
            this.value = valueMatcher.group().substring(1);
            bracketMatcher = this.bracketRegex.matcher(this.value);
            if (bracketMatcher.find()) {
                this.valueContext = bracketMatcher.group().replace("[", "").replace("]", "");
                this.value = this.value.substring(0, bracketMatcher.start()) + this.value.substring(bracketMatcher.end());
            }
        }
        String[] components = new String[4];
        String[] contexts = new String[4];
        String tagPart = null;
        Matcher componentMatcher = this.componentRegex.matcher(tag);
        for (int n = 0; componentMatcher.find() && n < 4; ++n) {
            tagPart = componentMatcher.group();
            bracketMatcher = this.bracketRegex.matcher(tagPart);
            if (bracketMatcher.find()) {
                components[n] = tagPart.substring(0, bracketMatcher.start());
                contexts[n] = bracketMatcher.group().replace("[", "").replace("]", "");
                continue;
            }
            components[n] = tagPart.replace(".", "");
        }
        this.name = components[0];
        this.nameContext = contexts[0];
        this.type = components[1];
        this.typeContext = contexts[1];
        this.subType = components[2];
        this.subTypeContext = contexts[2];
        this.specifier = components[3];
        this.specifierContext = contexts[3];
    }

    public String getName() {
        return this.name;
    }

    public String getNameContext() {
        return this.nameContext;
    }

    public boolean hasNameContext() {
        return this.nameContext != null;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getTypeContext() {
        return this.typeContext;
    }

    public boolean hasTypeContext() {
        return this.typeContext != null;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null;
    }

    public String getSubTypeContext() {
        return this.subTypeContext;
    }

    public boolean hasSubTypeContext() {
        return this.subTypeContext != null;
    }

    public String getSpecifier() {
        return this.specifier;
    }

    public boolean hasSpecifier() {
        return this.specifier != null;
    }

    public String getSpecifierContext() {
        return this.specifierContext;
    }

    public boolean hasSpecifierContext() {
        return this.specifierContext != null;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValueContext() {
        return this.valueContext;
    }

    public boolean hasValueContext() {
        return this.valueContext != null;
    }

    public String getAlternative() {
        return this.alternative;
    }

    public boolean hasAlternative() {
        return this.alternative != null;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public dNPC getNPC() {
        return this.npc;
    }

    public dPlayer getPlayer() {
        return this.player;
    }

    public String getReplaced() {
        return this.replaced;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public boolean matches(String tagName) {
        String[] tagNames;
        for (String string : tagNames = tagName.split(",")) {
            if (!this.name.equalsIgnoreCase(string.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean replaced() {
        return this.wasReplaced;
    }

    public void setReplaced(String string) {
        this.replaced = string;
        this.wasReplaced = true;
    }

    @Deprecated
    private void parseContext() {
        dB.log("Using 'context' in this way has been deprecated, as it is now possible to specify specific objects.");
    }

    public boolean hasScriptEntryAttached() {
        return this.scriptEntry != null;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public String toString() {
        return (this.instant ? "Instant=true," : "") + "Player=" + (this.player != null ? this.player.identify() : "null") + ", " + "NPC=" + (this.npc != null ? this.npc.getName() : "null") + ", " + "NAME=" + (this.nameContext != null ? this.name + "(" + this.nameContext + "), " : this.name + ", ") + (this.type != null ? (this.typeContext != null ? "TYPE=" + this.type + "(" + this.typeContext + "), " : "TYPE=" + this.type + ", ") : "") + (this.subType != null ? (this.subTypeContext != null ? "SUBTYPE=" + this.subType + "(" + this.subTypeContext + "), " : "SUBTYPE=" + this.subType + ", ") : "") + (this.specifier != null ? (this.specifierContext != null ? "SPECIFIER=" + this.specifier + "(" + this.specifierContext + "), " : "SPECIFIER=" + this.specifier + ", ") : "") + (this.value != null ? (this.valueContext != null ? "VALUE=" + this.value + "(" + this.valueContext + "), " : "VALUE=" + this.value + ", ") : "") + (this.alternative != null ? "ALTERNATIVE=" + this.alternative + ", " : "");
    }
}

