/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.events.bukkit.ScriptReloadEvent;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;

public class ScriptHelper {
    private static YamlConfiguration _yamlScripts = null;
    private static boolean HadAnError = false;

    public static void reloadScripts() {
        String concatenated = ScriptHelper._concatenateCoreScripts();
        _yamlScripts = new YamlConfiguration();
        try {
            _yamlScripts.loadFromString(concatenated);
        }
        catch (InvalidConfigurationException e) {
            dB.echoError("Could not load scripts!");
            dB.echoError(e);
        }
        ItemScriptHelper.removeDenizenRecipes();
        ScriptRegistry._buildCoreYamlScriptContainers(ScriptHelper.getScripts());
        Bukkit.getServer().getPluginManager().callEvent((Event)new ScriptReloadEvent());
    }

    public static FileConfiguration _gs() {
        return ScriptHelper.getScripts();
    }

    private static FileConfiguration getScripts() {
        if (_yamlScripts == null) {
            ScriptHelper.reloadScripts();
        }
        return _yamlScripts;
    }

    public static boolean getHadAnError() {
        return HadAnError;
    }

    public static void resetHadAnError() {
        HadAnError = false;
    }

    private static String _concatenateCoreScripts() {
        try {
            File file = new File(DenizenAPI.getCurrentInstance().getDataFolder() + File.separator + "scripts");
            if (!file.exists()) {
                dB.echoError("No script folder found, please create one.");
                HadAnError = true;
                return "";
            }
            List<File> files = Utilities.listDScriptFiles(file, Settings.LoadScriptsInSubfolders());
            if (files.size() > 0) {
                StringBuilder sb = new StringBuilder();
                dB.log("Processing 'util.dscript'... ");
                YamlConfiguration yaml = YamlConfiguration.loadConfiguration((InputStream)DenizenAPI.getCurrentInstance().getResource("util.dscript"));
                sb.append(yaml.saveToString() + "\r\n");
                dB.log("Processing outside scripts... ");
                for (FileConfiguration outsideConfig : ScriptRegistry.outside_scripts) {
                    try {
                        sb.append(outsideConfig.saveToString() + "\r\n");
                    }
                    catch (Exception e) {
                        dB.echoError("Woah! Error parsing outside scripts!");
                        HadAnError = true;
                    }
                }
                for (File f : files) {
                    String fileName = f.getAbsolutePath().substring(file.getAbsolutePath().length());
                    dB.log("Processing '" + fileName + "'... ");
                    try {
                        yaml = YamlConfiguration.loadConfiguration((File)f);
                        String saved = yaml.saveToString();
                        if (yaml != null && saved.length() > 0) {
                            sb.append(saved + "\r\n");
                            continue;
                        }
                        dB.echoError(ChatColor.RED + "Woah! Error parsing " + fileName + "! This script has been skipped. See console for YAML errors.");
                        HadAnError = true;
                    }
                    catch (RuntimeException e) {
                        dB.echoError(ChatColor.RED + "Woah! Error parsing " + fileName + "!");
                        HadAnError = true;
                        dB.echoError(e);
                    }
                }
                dB.echoApproval("All scripts loaded!");
                return ScriptHelper.yamlKeysToUpperCase(sb.toString());
            }
            dB.echoError(ChatColor.RED + "Woah! No scripts in /plugins/Denizen/scripts/ to load!");
            HadAnError = true;
        }
        catch (Exception e) {
            dB.echoError(ChatColor.RED + "Woah! No script folder found in /plugins/Denizen/scripts/");
            HadAnError = true;
            dB.echoError(e);
        }
        return "";
    }

    private static String yamlKeysToUpperCase(String string) {
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("(^.*?[^\\s](:\\s))", 8);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group().toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

