/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class QueueCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                if (scriptEntry.getObject("action") != Action.DELAY || !arg.matchesArgumentType(Duration.class)) continue;
                scriptEntry.addObject("delay", arg.asType(Duration.class));
                continue;
            }
            if (ScriptQueue._getExistingQueue(arg.getValue()) != null) {
                scriptEntry.addObject("queue", ScriptQueue._getExistingQueue(arg.getValue()));
                continue;
            }
            throw new InvalidArgumentsException("The specified queue could not be found: " + arg.raw_value);
        }
        scriptEntry.defaultObject("queue", scriptEntry.getResidingQueue());
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action. Valid: CLEAR, DELAY, PAUSE, RESUME");
        }
        if (scriptEntry.getObject("action") == Action.DELAY && !scriptEntry.hasObject("delay")) {
            throw new InvalidArgumentsException("Must specify a delay.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Duration delay = (Duration)scriptEntry.getObject("delay");
        dB.report(scriptEntry, this.getName(), aH.debugObj("Queue", queue.id) + aH.debugObj("Action", action.toString()) + (action == Action.DELAY ? delay.debug() : ""));
        switch (action) {
            case CLEAR: {
                queue.clear();
                return;
            }
            case STOP: {
                queue.stop();
                return;
            }
            case PAUSE: {
                if (queue instanceof TimedQueue) {
                    ((TimedQueue)queue).setPaused(true);
                }
                return;
            }
            case RESUME: {
                if (queue instanceof TimedQueue) {
                    ((TimedQueue)queue).setPaused(false);
                }
                return;
            }
            case DELAY: {
                if (queue instanceof TimedQueue) {
                    ((TimedQueue)queue).delayFor(delay);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        CLEAR,
        DELAY,
        PAUSE,
        RESUME,
        STOP;

    }
}

