/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import org.bukkit.entity.LivingEntity;

public class ChatCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_targets = false;
        boolean specified_talker = false;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("target, targets, t")) {
                if (arg.matchesArgumentList(dEntity.class)) {
                    scriptEntry.addObject("targets", arg.asType(dList.class));
                }
                specified_targets = true;
                continue;
            }
            if (arg.matches("no_target")) {
                scriptEntry.addObject("targets", Element.FALSE);
                continue;
            }
            if (arg.matchesPrefix("talker, talkers")) {
                if (arg.matchesArgumentList(dEntity.class)) {
                    scriptEntry.addObject("talkers", arg.asType(dList.class));
                }
                specified_talker = true;
                continue;
            }
            scriptEntry.addObject("message", new Element(arg.raw_value));
        }
        if (!scriptEntry.hasObject("targets") && scriptEntry.hasPlayer() && !specified_targets) {
            scriptEntry.defaultObject("targets", scriptEntry.getPlayer());
        }
        if (!scriptEntry.hasObject("talkers") && scriptEntry.hasNPC() && !specified_talker) {
            scriptEntry.defaultObject("talkers", new dList(scriptEntry.getNPC().identify()));
        }
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify valid targets!");
        }
        if (!scriptEntry.hasObject("talkers")) {
            throw new InvalidArgumentsException("Must specify valid talkers!");
        }
        if (!scriptEntry.hasObject("message")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dList talkers = (dList)scriptEntry.getdObject("talkers");
        dObject targets = scriptEntry.getdObject("targets");
        Element message = scriptEntry.getElement("message");
        dB.report(scriptEntry, this.getName(), talkers.debug() + targets.debug() + message.debug());
        SpeechContext context = new SpeechContext(message.asString());
        if (!targets.equals(Element.FALSE)) {
            if (targets instanceof dPlayer) {
                dPlayer player = (dPlayer)targets;
                if (player.isOnline()) {
                    context.addRecipient((LivingEntity)player.getPlayerEntity());
                }
            } else {
                dList target_list = (dList)targets;
                for (dObject obj : target_list.filter(dEntity.class)) {
                    dEntity ent = (dEntity)obj;
                    if (!ent.isLivingEntity()) continue;
                    context.addRecipient(ent.getLivingEntity());
                }
            }
        }
        for (String talker : talkers) {
            if (dNPC.matches(talker)) {
                dNPC npc = dNPC.valueOf(talker);
                context.setTalker(npc.getEntity());
                npc.getCitizen().getDefaultSpeechController().speak(context, "chat");
                continue;
            }
            if (!dPlayer.matches(talker)) continue;
        }
    }
}

