/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadCommand
extends AbstractCommand
implements Listener {
    Map<String, Long> chunkDelays = new HashMap<String, Long>();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Object chunk = null;
        Duration length = new Duration(0);
        Action action = Action.ADD;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", new Element(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(dLocation.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matchesArgumentType(Duration.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", new Element("ADD"));
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new Duration(0));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element action = scriptEntry.getElement("action");
        dLocation chunkloc = (dLocation)scriptEntry.getObject("location");
        Duration length = (Duration)scriptEntry.getObject("duration");
        dB.report(scriptEntry, this.getName(), action.debug() + chunkloc.debug() + length.debug());
        Chunk chunk = chunkloc.getChunk();
        String chunkString = chunk.getX() + ", " + chunk.getZ();
        switch (Action.valueOf(action.asString())) {
            case ADD: {
                if (length.getSeconds() != 0.0) {
                    this.chunkDelays.put(chunkString, System.currentTimeMillis() + length.getMillis());
                } else {
                    this.chunkDelays.put(chunkString, 0L);
                }
                dB.echoDebug((Debuggable)scriptEntry, "...added chunk " + chunk.getX() + ", " + chunk.getZ() + " with a delay of " + length.getSeconds() + " seconds.");
                if (chunk.isLoaded()) break;
                chunk.load();
                break;
            }
            case REMOVE: {
                if (this.chunkDelays.containsKey(chunkString)) {
                    this.chunkDelays.remove(chunkString);
                    dB.echoDebug((Debuggable)scriptEntry, "...allowing unloading of chunk " + chunk.getX() + ", " + chunk.getZ());
                    break;
                }
                dB.echoError("Chunk was not on the load list!");
                break;
            }
            case REMOVEALL: {
                dB.echoDebug((Debuggable)scriptEntry, "...allowing unloading of all stored chunks");
                this.chunkDelays.clear();
            }
        }
    }

    @EventHandler
    public void stopUnload(ChunkUnloadEvent e) {
        String chunkString = e.getChunk().getX() + ", " + e.getChunk().getZ();
        if (this.chunkDelays.containsKey(chunkString)) {
            if (this.chunkDelays.get(chunkString) == 0L) {
                e.setCancelled(true);
            } else if (System.currentTimeMillis() < this.chunkDelays.get(chunkString)) {
                e.setCancelled(true);
            } else {
                this.chunkDelays.remove(chunkString);
            }
        }
    }

    @EventHandler
    public void stopDespawn(NPCDespawnEvent e) {
        Chunk chnk = e.getNPC().getEntity().getLocation().getChunk();
        String chunkString = chnk.getX() + ", " + chnk.getZ();
        if (this.chunkDelays.containsKey(chunkString)) {
            if (this.chunkDelays.get(chunkString) == 0L) {
                e.setCancelled(true);
            } else if (System.currentTimeMillis() < this.chunkDelays.get(chunkString)) {
                e.setCancelled(true);
            } else {
                this.chunkDelays.remove(chunkString);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        REMOVEALL;

    }
}

