/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets.handler;

import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.traits.NameplateTrait;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NameplateHandler
extends PacketAdapter {
    public NameplateHandler(Denizen denizen) {
        super((Plugin)denizen, ConnectionSide.SERVER_SIDE, new Integer[]{20});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled() || event.getPacketID() != 20) {
            return;
        }
        PacketContainer packet = event.getPacket();
        StructureModifier text = packet.getSpecificModifier(String.class);
        try {
            Player observer = event.getPlayer();
            Entity watched = (Entity)packet.getEntityModifier(observer.getWorld()).read(0);
            NPCRegistry npcRegistry = CitizensAPI.getNPCRegistry();
            if (npcRegistry == null) {
                return;
            }
            for (NPC npc : npcRegistry) {
                Entity npcEntity;
                if (!npc.hasTrait(NameplateTrait.class) || (npcEntity = npc.getEntity()) == null || !npcEntity.equals(watched)) continue;
                NameplateTrait trait = (NameplateTrait)npc.getTrait(NameplateTrait.class);
                text.write(0, (Object)trait.getTrimmedTag(observer.getName()));
                return;
            }
        }
        catch (FieldAccessException e) {
            // empty catch block
        }
    }
}

