/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.bukkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class ReplaceableTagEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final dPlayer player;
    private final dNPC npc;
    private boolean instant = false;
    private boolean wasReplaced = false;
    private String name = null;
    private String nameContext = null;
    private String type = null;
    private String typeContext = null;
    private String subType = null;
    private String subTypeContext = null;
    private String specifier = null;
    private String specifierContext = null;
    private String value = null;
    private String valueContext = null;
    private String alternative = null;
    private String replaced = null;
    private ScriptEntry scriptEntry = null;
    private static Pattern bracketReplaceRegex = Pattern.compile("[\\[\\]]");
    private static Pattern alternativeRegex = Pattern.compile("\\|\\|(.*)");
    private static Pattern bracketRegex = Pattern.compile("\\[.*?\\]");
    private static Pattern valueRegex = Pattern.compile(":([^\\]]+(\\[([^\\[])+)?)$");
    private static Pattern componentRegex = Pattern.compile("[^\\[\\]\\.]+(\\[.*?\\])?(\\.)?(\\d+[^\\.]*\\.?)*");
    public String raw_tag;

    public ReplaceableTagEvent(dPlayer player, dNPC npc, String tag) {
        this(player, npc, tag, null);
    }

    public ReplaceableTagEvent(dPlayer player, dNPC npc, String tag, ScriptEntry scriptEntry) {
        Matcher alternativeMatcher;
        char start;
        this.scriptEntry = scriptEntry;
        this.player = player;
        this.replaced = tag;
        this.npc = npc;
        if (tag.length() > 0 && ((start = tag.charAt(0)) == '!' || start == '^')) {
            this.instant = true;
            tag = tag.substring(1);
        }
        if ((alternativeMatcher = alternativeRegex.matcher(tag)).find()) {
            tag = tag.substring(0, alternativeMatcher.start()).trim();
            this.alternative = alternativeMatcher.group(1).trim();
        }
        this.raw_tag = tag;
        Matcher bracketMatcher = null;
        Matcher valueMatcher = valueRegex.matcher(tag);
        if (valueMatcher.find()) {
            tag = tag.substring(0, valueMatcher.start());
            this.value = valueMatcher.group(1);
            bracketMatcher = bracketRegex.matcher(this.value);
            if (bracketMatcher.find()) {
                this.valueContext = bracketReplaceRegex.matcher(bracketMatcher.group()).replaceAll("");
                this.value = this.value.substring(0, bracketMatcher.start()) + this.value.substring(bracketMatcher.end());
            }
        }
        String tagPart = null;
        Matcher componentMatcher = componentRegex.matcher(tag);
        block6: for (int n = 0; componentMatcher.find() && n < 4; ++n) {
            tagPart = componentMatcher.group();
            bracketMatcher = bracketRegex.matcher(tagPart);
            String component = null;
            String context = null;
            if (bracketMatcher.find()) {
                component = tagPart.substring(0, bracketMatcher.start());
                context = bracketReplaceRegex.matcher(bracketMatcher.group()).replaceAll("");
            } else {
                component = tagPart.endsWith(".") ? tagPart.substring(0, tagPart.length() - 1) : tagPart;
            }
            switch (n) {
                case 0: {
                    this.name = component;
                    this.nameContext = context;
                    continue block6;
                }
                case 1: {
                    this.type = component;
                    this.typeContext = context;
                    continue block6;
                }
                case 2: {
                    this.subType = component;
                    this.subTypeContext = context;
                    continue block6;
                }
                case 3: {
                    this.specifier = component;
                    this.specifierContext = context;
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNameContext() {
        return this.nameContext;
    }

    public boolean hasNameContext() {
        return this.nameContext != null;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getTypeContext() {
        return this.typeContext;
    }

    public boolean hasTypeContext() {
        return this.typeContext != null;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null;
    }

    public String getSubTypeContext() {
        return this.subTypeContext;
    }

    public boolean hasSubTypeContext() {
        return this.subTypeContext != null;
    }

    public String getSpecifier() {
        return this.specifier;
    }

    public boolean hasSpecifier() {
        return this.specifier != null;
    }

    public String getSpecifierContext() {
        return this.specifierContext;
    }

    public boolean hasSpecifierContext() {
        return this.specifierContext != null;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValueContext() {
        return this.valueContext;
    }

    public boolean hasValueContext() {
        return this.valueContext != null;
    }

    public String getAlternative() {
        return this.alternative;
    }

    public boolean hasAlternative() {
        return this.alternative != null;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public dNPC getNPC() {
        return this.npc;
    }

    public dPlayer getPlayer() {
        return this.player;
    }

    public String getReplaced() {
        return this.replaced;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public boolean matches(String tagName) {
        String[] tagNames;
        for (String string : tagNames = tagName.split(",")) {
            if (!this.name.equalsIgnoreCase(string.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean replaced() {
        return this.wasReplaced;
    }

    public void setReplaced(String string) {
        this.replaced = string;
        this.wasReplaced = true;
    }

    @Deprecated
    private void parseContext() {
        dB.log("Using 'context' in this way has been deprecated, as it is now possible to specify specific objects.");
    }

    public boolean hasScriptEntryAttached() {
        return this.scriptEntry != null;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public String toString() {
        return (this.instant ? "Instant=true," : "") + "Player=" + (this.player != null ? this.player.identify() : "null") + ", " + "NPC=" + (this.npc != null ? this.npc.getName() : "null") + ", " + "NAME=" + (this.nameContext != null ? this.name + "(" + this.nameContext + "), " : this.name + ", ") + (this.type != null ? (this.typeContext != null ? "TYPE=" + this.type + "(" + this.typeContext + "), " : "TYPE=" + this.type + ", ") : "") + (this.subType != null ? (this.subTypeContext != null ? "SUBTYPE=" + this.subType + "(" + this.subTypeContext + "), " : "SUBTYPE=" + this.subType + ", ") : "") + (this.specifier != null ? (this.specifierContext != null ? "SPECIFIER=" + this.specifier + "(" + this.specifierContext + "), " : "SPECIFIER=" + this.specifier + ", ") : "") + (this.value != null ? (this.valueContext != null ? "VALUE=" + this.value + "(" + this.valueContext + "), " : "VALUE=" + this.value + ", ") : "") + (this.alternative != null ? "ALTERNATIVE=" + this.alternative + ", " : "");
    }
}

