/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Adjustable;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.Fetchable;
import net.aufdemrand.denizen.objects.Mechanism;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.notable.Note;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.objects.properties.PropertyParser;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.blocks.SafeBlock;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dCuboid
implements dObject,
Notable,
Adjustable {
    List<LocationPair> pairs = new ArrayList<LocationPair>();
    ArrayList<dObject> filter = new ArrayList();
    String prefix = "Cuboid";

    public static List<dCuboid> getNotableCuboidsContaining(Location location) {
        ArrayList<dCuboid> cuboids = new ArrayList<dCuboid>();
        for (dObject notable : NotableManager.getAllType(dCuboid.class)) {
            if (!((dCuboid)notable).isInsideCuboid(location)) continue;
            cuboids.add((dCuboid)notable);
        }
        return cuboids;
    }

    @Fetchable(value="cu")
    public static dCuboid valueOf(String string) {
        if (string == null) {
            return null;
        }
        String[] positions = string.replace("cu@", "").split("\\|");
        if (dLocation.matches(positions[0]) && dLocation.matches(positions[1])) {
            dLocation pos_1 = dLocation.valueOf(positions[0]);
            dLocation pos_2 = dLocation.valueOf(positions[1]);
            if (pos_1 == null || pos_2 == null) {
                dB.echoError("valueOf in dCuboid returning null: '" + string + "'.");
                return null;
            }
            if (pos_1.getWorld() != pos_2.getWorld()) {
                dB.echoError("Worlds must match on cuboid construction.");
                return null;
            }
            return new dCuboid(pos_1, pos_2);
        }
        Pattern item_by_saved = Pattern.compile("(cu@)(.+)");
        Matcher m = item_by_saved.matcher(string);
        if (m.matches() && NotableManager.isType(m.group(2), dCuboid.class)) {
            return (dCuboid)NotableManager.getSavedObject(m.group(2));
        }
        dB.echoError("valueOf dCuboid returning null: " + string);
        return null;
    }

    public static boolean matches(String string) {
        if (string.toLowerCase().startsWith("cu@")) {
            return true;
        }
        Pattern location_by_saved = Pattern.compile("(cu@)?(.+)");
        Pattern location = Pattern.compile("((-?\\d+,){3})[\\w\\s]+\\|((-?\\d+,){3})[\\w\\s]+", 2);
        Matcher m = location_by_saved.matcher(string);
        if (m.matches() && NotableManager.isType(m.group(2), dCuboid.class)) {
            return true;
        }
        m = location.matcher(string.replace("cu@", ""));
        return m.matches();
    }

    private dCuboid(Location point_1, Location point_2) {
        this.addPair(point_1, point_2);
    }

    public void addPair(Location point_1, Location point_2) {
        LocationPair pair = new LocationPair(new dLocation(point_1), new dLocation(point_2));
        this.pairs.add(pair);
    }

    public boolean isInsideCuboid(Location location) {
        for (LocationPair pair : this.pairs) {
            if (!location.getWorld().equals(pair.low.getWorld()) || !Utilities.isBetween(pair.low.getBlockX(), pair.high.getBlockX(), location.getBlockX()) || !Utilities.isBetween(pair.low.getBlockY(), pair.high.getBlockY(), location.getBlockY()) || !Utilities.isBetween(pair.low.getBlockZ(), pair.high.getBlockZ(), location.getZ())) continue;
            return true;
        }
        return false;
    }

    public dCuboid addBlocksToFilter(List<dMaterial> addl) {
        this.filter.addAll(addl);
        return this;
    }

    public dCuboid removeBlocksFromFilter(List<dMaterial> addl) {
        this.filter.removeAll(addl);
        return this;
    }

    public dCuboid removeFilter() {
        this.filter.clear();
        return this;
    }

    public dCuboid setAsFilter(List<dMaterial> list) {
        this.filter.clear();
        this.filter.addAll(list);
        return this;
    }

    public dList getOutline() {
        dList list = new dList();
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            dLocation loc_2 = pair.high;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int y = loc_1.getBlockY(); y <= loc_1.getBlockY() + y_distance; ++y) {
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), y, loc_1.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), y, loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), y, loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), y, loc_1.getBlockZ()).identify());
            }
            for (int x = loc_1.getBlockX(); x <= loc_1.getBlockX() + x_distance; ++x) {
                list.add(new dLocation(loc_1.getWorld(), x, loc_1.getBlockY(), loc_1.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), x, loc_1.getBlockY(), loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), x, loc_2.getBlockY(), loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), x, loc_2.getBlockY(), loc_1.getBlockZ()).identify());
            }
            for (int z = loc_1.getBlockZ(); z <= loc_1.getBlockZ() + z_distance; ++z) {
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), loc_1.getBlockY(), z).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), loc_2.getBlockY(), z).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), loc_2.getBlockY(), z).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), loc_1.getBlockY(), z).identify());
            }
        }
        return list;
    }

    public dList getBlocks() {
        dList list = new dList();
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int z = 0; z != z_distance + 1; ++z) {
                    for (int y = 0; y != y_distance + 1; ++y) {
                        dLocation loc = new dLocation(loc_1.clone().add((double)x, (double)y, (double)z));
                        if (!this.filter.isEmpty()) {
                            for (dObject material : this.filter) {
                                if (!loc.getBlock().getType().name().equalsIgnoreCase(((dMaterial)material).getMaterial().name())) continue;
                                list.add(loc.identify());
                            }
                            continue;
                        }
                        list.add(loc.identify());
                    }
                }
            }
        }
        return list;
    }

    public dList getSpawnableBlocks() {
        dList list = new dList();
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int z = 0; z != z_distance + 1; ++z) {
                    for (int y = 0; y != y_distance; ++y) {
                        dLocation loc = new dLocation(loc_1.clone().add((double)x, (double)y, (double)z));
                        if (!SafeBlock.blockIsSafe(loc.getBlock().getType()) || !SafeBlock.blockIsSafe(loc.clone().add(0.0, 1.0, 0.0).getBlock().getType()) || !loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid()) continue;
                        loc.add(0.5, 0.0, 0.5);
                        list.add(loc.identify());
                    }
                }
            }
        }
        return list;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="cuboid")
    public String getSaveObject() {
        StringBuilder sb = new StringBuilder();
        for (LocationPair pair : this.pairs) {
            sb.append(pair.low.getBlockX() + 44 + pair.low.getBlockY() + "," + pair.low.getBlockZ() + ',' + pair.low.getWorld().getName() + '|' + pair.high.getBlockX() + ',' + pair.high.getBlockY() + ',' + pair.high.getBlockZ() + ',' + pair.high.getWorld().getName() + '|');
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dCuboid setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.isUnique() ? "<G>" + this.prefix + "='<A>" + NotableManager.getSavedId(this) + "(<Y>" + this.identify() + "<A>)<G>'  " : "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("cu@");
        for (LocationPair pair : this.pairs) {
            sb.append(pair.low.getBlockX() + 44 + pair.low.getBlockY() + "," + pair.low.getBlockZ() + ',' + pair.low.getWorld().getName() + '|' + pair.high.getBlockX() + ',' + pair.high.getBlockY() + ',' + pair.high.getBlockZ() + ',' + pair.high.getWorld().getName() + '|');
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("get_blocks")) {
            return new dList(this.getBlocks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("members_size")) {
            return new Element(this.pairs.size()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get_member")) {
            int member = attribute.getIntContext(1);
            if (member == 0) {
                return "null";
            }
            if (member - 1 > this.pairs.size()) {
                return "null";
            }
            return new dCuboid(this.pairs.get((int)(member - 1)).low, this.pairs.get((int)(member - 1)).high).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get_spawnable_blocks")) {
            return new dList(this.getSpawnableBlocks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get_outline")) {
            return new dList(this.getOutline()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("filter")) {
            return new dList(this.filter).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within")) {
            dLocation loc = dLocation.valueOf(attribute.getContext(1));
            return new Element(this.isInsideCuboid(loc)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max")) {
            if (!attribute.hasContext(1)) {
                return this.pairs.get((int)0).high.getAttribute(attribute.fulfill(1));
            }
            int member = attribute.getIntContext(1);
            if (member == 0) {
                return "null";
            }
            if (member - 1 > this.pairs.size()) {
                return "null";
            }
            return this.pairs.get((int)(member - 1)).high.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("min")) {
            if (!attribute.hasContext(1)) {
                return this.pairs.get((int)0).low.getAttribute(attribute.fulfill(1));
            }
            int member = attribute.getIntContext(1);
            if (member == 0) {
                return "null";
            }
            if (member - 1 > this.pairs.size()) {
                return "null";
            }
            return this.pairs.get((int)(member - 1)).low.getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("outset")) {
            int mod = 1;
            if (value == null || mechanism.requireInteger("Invalid integer specified. Assuming '1'.")) {
                // empty if block
            }
            mod = value.asInt();
            for (LocationPair pair : this.pairs) {
                pair.low.add(-1 * mod, -1 * mod, -1 * mod);
                pair.high.add(mod, mod, mod);
                pair.generateDistances();
            }
            return;
        }
        if (mechanism.matches("expand")) {
            int mod = 1;
            if (value != null && mechanism.requireInteger("Invalid integer specified. Assuming '1'.")) {
                mod = value.asInt();
            }
            for (LocationPair pair : this.pairs) {
                pair.low.add(-1 * mod, -1 * mod, -1 * mod);
                pair.high.add(mod, mod, mod);
                pair.generateDistances();
            }
            return;
        }
        if (mechanism.matches("set_location")) {
            int mod = 1;
            if (value != null && mechanism.requireInteger("Invalid integer specified. Assuming '1'.")) {
                mod = value.asInt();
            }
            for (LocationPair pair : this.pairs) {
                pair.low.add(-1 * mod, -1 * mod, -1 * mod);
                pair.high.add(mod, mod, mod);
                pair.generateDistances();
            }
            return;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }

    public static class LocationPair {
        dLocation low;
        dLocation high;
        dLocation point_1;
        dLocation point_2;
        int x_distance;
        int y_distance;
        int z_distance;

        public LocationPair(dLocation point_1, dLocation point_2) {
            this.point_1 = point_1;
            this.point_2 = point_2;
            this.regenerate();
        }

        public void changePoint(int number, dLocation point) {
            if (number == 1) {
                this.point_1 = point;
            } else if (number == 2) {
                this.point_2 = point;
            }
            this.regenerate();
        }

        public void regenerate() {
            World world = this.point_1.getWorld();
            int x_high = this.point_1.getBlockX() >= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int x_low = this.point_1.getBlockX() <= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int y_high = this.point_1.getBlockY() >= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int y_low = this.point_1.getBlockY() <= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int z_high = this.point_1.getBlockZ() >= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            int z_low = this.point_1.getBlockZ() <= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            this.low = new dLocation(world, x_low, y_low, z_low);
            this.high = new dLocation(world, x_high, y_high, z_high);
            this.generateDistances();
        }

        public void generateDistances() {
            this.x_distance = this.high.getBlockX() - this.low.getBlockX();
            this.y_distance = this.high.getBlockY() - this.low.getBlockY();
            this.z_distance = this.high.getBlockZ() - this.low.getBlockZ();
        }
    }
}

