/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.notable;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.Note;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotableManager {
    public static Map<String, Notable> notableObjects = new ConcurrentHashMap<String, Notable>();
    public static Map<String, Class> typeTracker = new ConcurrentHashMap<String, Class>();
    public static Map<Notable, String> reverseObjects = new ConcurrentHashMap<Notable, String>();
    private FileConfiguration notablesSave = null;
    private File notablesFile = null;
    private static Map<Class, String> objects = new HashMap<Class, String>();
    private static ArrayList<Class> notable_objects = new ArrayList();

    public NotableManager() {
        try {
            NotableManager._initialize();
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isSaved(String id) {
        return notableObjects.containsKey(id.toLowerCase());
    }

    public static boolean isSaved(Notable object) {
        return reverseObjects.containsKey(object);
    }

    public static Notable getSavedObject(String id) {
        if (notableObjects.containsKey(id.toLowerCase())) {
            return notableObjects.get(id.toLowerCase());
        }
        return null;
    }

    public static String getSavedId(Notable object) {
        if (reverseObjects.containsKey(object)) {
            return reverseObjects.get(object);
        }
        return null;
    }

    public static boolean isType(String id, Class type) {
        return typeTracker.containsKey(id.toLowerCase()) && typeTracker.get(id.toLowerCase()) == type;
    }

    public static void saveAs(Notable object, String id) {
        if (object == null) {
            return;
        }
        notableObjects.put(id.toLowerCase(), object);
        reverseObjects.put(object, id.toLowerCase());
        typeTracker.put(id.toLowerCase(), object.getClass());
    }

    public static void remove(String id) {
        Notable obj = notableObjects.get(id.toLowerCase());
        notableObjects.remove(id.toLowerCase());
        reverseObjects.remove(obj);
        typeTracker.remove(id.toLowerCase());
    }

    public static void remove(Notable obj) {
        String id = reverseObjects.get(obj);
        notableObjects.remove(id.toLowerCase());
        reverseObjects.remove(obj);
        typeTracker.remove(id.toLowerCase());
    }

    public static List<dObject> getAllType(Class<? extends dObject> type) {
        ArrayList<dObject> objects = new ArrayList<dObject>();
        for (Map.Entry<String, Notable> notable : notableObjects.entrySet()) {
            if (!NotableManager.isType(notable.getKey(), type)) continue;
            objects.add((dObject)((Object)notable.getValue()));
        }
        return objects;
    }

    private static void _recallNotables() {
        for (String string : DenizenAPI.getCurrentInstance().notableManager().getNotables().getKeys(false)) {
        }
    }

    private static void _saveNotables() {
        for (Map.Entry<String, Notable> notable : notableObjects.entrySet()) {
            if (notable.getValue().getSaveObject() instanceof ConfigurationSerializable) {
                DenizenAPI.getCurrentInstance().notableManager().getNotables().set(((dObject)((Object)notable.getValue())).getObjectType().toLowerCase() + "." + "_serializable", (Object)true);
            }
            DenizenAPI.getCurrentInstance().notableManager().getNotables().set(((dObject)((Object)notable.getValue())).getObjectType().toLowerCase() + "." + notable.getKey().toLowerCase(), (Object)notable.getValue());
        }
    }

    public void reloadNotables() {
        if (this.notablesFile == null) {
            this.notablesFile = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "notables.yml");
        }
        this.notablesSave = YamlConfiguration.loadConfiguration((File)this.notablesFile);
        NotableManager._recallNotables();
    }

    public FileConfiguration getNotables() {
        if (this.notablesSave == null) {
            this.reloadNotables();
        }
        return this.notablesSave;
    }

    public void saveNotables() {
        if (this.notablesSave == null || this.notablesFile == null) {
            return;
        }
        try {
            NotableManager._saveNotables();
            this.notablesSave.save(this.notablesFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.notablesFile, ex);
        }
    }

    public static void _initialize() throws IOException, ClassNotFoundException {
        objects.clear();
        for (Class dClass : notable_objects) {
            for (Method method : dClass.getMethods()) {
                String[] identifiers;
                if (!method.isAnnotationPresent(Note.class)) continue;
                for (String identifer : identifiers = method.getAnnotation(Note.class).value().split(",")) {
                    objects.put(dClass, identifer.trim().toLowerCase());
                }
            }
        }
    }

    public static void registerWithNotableManager(Class notable) {
        notable_objects.add(notable);
    }

    public static boolean canFetch(Class notable) {
        return objects.containsKey(notable);
    }

    public static String getClassId(Class notable) {
        if (NotableManager.canFetch(notable)) {
            return objects.get(notable).toLowerCase();
        }
        return null;
    }
}

