/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.entity.LivingEntity;

public class EquipCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        HashMap<String, dItem> equipment = new HashMap<String, dItem>();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("head, helmet")) {
                equipment.put("head", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("chest, chestplate")) {
                equipment.put("chest", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("legs, leggings")) {
                equipment.put("legs", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && arg.matchesPrefix("boots, feet")) {
                equipment.put("boots", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class)) {
                equipment.put("hand", dItem.valueOf(arg.getValue()));
                continue;
            }
            if (arg.matches("player") && scriptEntry.hasPlayer()) {
                scriptEntry.addObject("entities", Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (equipment.isEmpty()) {
            throw new InvalidArgumentsException("Must specify equipment!");
        }
        scriptEntry.addObject("equipment", equipment);
        scriptEntry.defaultObject("entities", scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null, scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Map equipment = (Map)scriptEntry.getObject("equipment");
        List entities = (List)scriptEntry.getObject("entities");
        dB.report(scriptEntry, this.getName(), aH.debugObj("entities", entities.toString()) + aH.debugObj("equipment", equipment.toString()));
        for (dEntity entity : entities) {
            if (entity.isGeneric()) {
                dB.echoError("Cannot equip generic entity " + entity.identify() + "!");
                continue;
            }
            if (entity.isNPC()) {
                NPC npc = entity.getNPC();
                if (npc == null) continue;
                if (!npc.hasTrait(Equipment.class)) {
                    npc.addTrait(Equipment.class);
                }
                Equipment trait = (Equipment)npc.getTrait(Equipment.class);
                if (equipment.get("hand") != null) {
                    trait.set(0, ((dItem)equipment.get("hand")).getItemStack());
                }
                if (equipment.get("head") != null) {
                    trait.set(1, ((dItem)equipment.get("head")).getItemStack());
                }
                if (equipment.get("chest") != null) {
                    trait.set(2, ((dItem)equipment.get("chest")).getItemStack());
                }
                if (equipment.get("legs") != null) {
                    trait.set(3, ((dItem)equipment.get("legs")).getItemStack());
                }
                if (equipment.get("boots") == null) continue;
                trait.set(4, ((dItem)equipment.get("boots")).getItemStack());
                continue;
            }
            LivingEntity livingEntity = entity.getLivingEntity();
            if (livingEntity == null) continue;
            if (equipment.get("hand") != null) {
                livingEntity.getEquipment().setItemInHand(((dItem)equipment.get("hand")).getItemStack());
            }
            if (equipment.get("head") != null) {
                livingEntity.getEquipment().setHelmet(((dItem)equipment.get("head")).getItemStack());
            }
            if (equipment.get("chest") != null) {
                livingEntity.getEquipment().setChestplate(((dItem)equipment.get("chest")).getItemStack());
            }
            if (equipment.get("legs") != null) {
                livingEntity.getEquipment().setLeggings(((dItem)equipment.get("legs")).getItemStack());
            }
            if (equipment.get("boots") == null) continue;
            livingEntity.getEquipment().setBoots(((dItem)equipment.get("boots")).getItemStack());
        }
    }
}

