/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class RemoveCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("region") && arg.matchesPrefix("region, r")) {
                scriptEntry.addObject("region", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        scriptEntry.defaultObject("world", scriptEntry.hasNPC() && scriptEntry.getNPC().isSpawned() ? new dWorld(scriptEntry.getNPC().getWorld()) : null, scriptEntry.hasPlayer() && scriptEntry.getPlayer().isOnline() ? new dWorld(scriptEntry.getPlayer().getWorld()) : null, new dWorld((World)Bukkit.getWorlds().get(0)));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Element region = (Element)scriptEntry.getObject("region");
        dB.report(scriptEntry, this.getName(), aH.debugObj("entities", entities.toString()) + (region != null ? aH.debugObj("region", region) : ""));
        for (dEntity entity : entities) {
            boolean conditionsMet = true;
            if (!entity.isGeneric()) {
                if (region != null) {
                    conditionsMet = WorldGuardUtilities.inRegion(entity.getBukkitEntity().getLocation(), region.asString());
                }
                if (!conditionsMet) continue;
                if (entity.isNPC()) {
                    entity.getNPC().destroy();
                    continue;
                }
                entity.remove();
                continue;
            }
            for (Entity worldEntity : world.getEntities()) {
                if (!entity.getEntityType().equals((Object)worldEntity.getType())) continue;
                if (region != null) {
                    conditionsMet = WorldGuardUtilities.inRegion(worldEntity.getLocation(), region.asString());
                }
                if (!conditionsMet) continue;
                worldEntity.remove();
            }
        }
    }
}

