/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.LookClose;

public class LookcloseCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("realistic, realistically")) {
                scriptEntry.addObject("realistic", Element.TRUE);
                continue;
            }
            if (arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("toggle", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(dNPC.class)) {
                scriptEntry.setNPC(arg.asType(dNPC.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.report(scriptEntry, this.getName(), scriptEntry.getNPC().debug() + scriptEntry.reportObject("realistic") + scriptEntry.reportObject("range") + scriptEntry.reportObject("toggle"));
        LookClose trait = (LookClose)scriptEntry.getNPC().getCitizen().getTrait(LookClose.class);
        if (scriptEntry.hasObject("toggle")) {
            trait.lookClose(scriptEntry.getElement("toggle").asBoolean());
        }
        if (scriptEntry.hasObject("realistic")) {
            trait.setRealisticLooking(true);
        } else {
            trait.setRealisticLooking(false);
        }
        if (scriptEntry.hasObject("range")) {
            trait.setRange(scriptEntry.getElement("range").asInt());
        }
    }
}

