/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;

public class MidiCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("tempo") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("tempo", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("file")) {
                String path = this.denizen.getDataFolder() + File.separator + "midi" + File.separator + arg.getValue();
                if (!path.endsWith(".mid")) {
                    path = path + ".mid";
                }
                scriptEntry.addObject("file", new Element(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("file") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Missing file (Midi name) argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            scriptEntry.defaultObject("entities", scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null, scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null);
        }
        scriptEntry.defaultObject("tempo", new Element(1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        File file;
        boolean cancel = scriptEntry.hasObject("cancel");
        File file2 = file = !cancel ? new File(scriptEntry.getElement("file").asString()) : null;
        if (!cancel && !file.exists()) {
            dB.echoError("Invalid file " + scriptEntry.getElement("file").asString());
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        float tempo = (float)scriptEntry.getElement("tempo").asDouble();
        dB.report(scriptEntry, this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + (file != null ? aH.debugObj("file", file.getPath()) : "") + (entities != null ? aH.debugObj("entities", entities.toString()) : "") + (location != null ? location.debug() : "") + aH.debugObj("tempo", Float.valueOf(tempo)));
        if (!cancel) {
            if (location != null) {
                MidiUtil.playMidi(file, tempo, location);
            } else {
                MidiUtil.playMidi(file, tempo, entities);
            }
        } else if (location != null) {
            MidiUtil.stopMidi(location.identify());
        } else {
            MidiUtil.stopMidi(entities);
        }
    }
}

