/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.WeatherType;

public class WeatherCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesEnum(Value.values())) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        scriptEntry.defaultObject("world", scriptEntry.hasNPC() ? new dWorld(scriptEntry.getNPC().getWorld()) : null, scriptEntry.hasPlayer() ? new dWorld(scriptEntry.getPlayer().getWorld()) : null, dWorld.valueOf("world"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Value value = Value.valueOf(((Element)scriptEntry.getObject("value")).asString().toUpperCase());
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Type type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.GLOBAL;
        dB.report(scriptEntry, this.getName(), aH.debugObj("type", type.name()) + (type.name().equalsIgnoreCase("player") ? aH.debugObj("player", scriptEntry.getPlayer()) : "") + (type.name().equalsIgnoreCase("global") ? aH.debugObj("world", world) : "") + aH.debugObj("value", (Object)value));
        switch (value) {
            case SUNNY: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setStorm(false);
                    world.getWorld().setThundering(false);
                    break;
                }
                scriptEntry.getPlayer().getPlayerEntity().setPlayerWeather(WeatherType.CLEAR);
                break;
            }
            case STORM: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setStorm(true);
                    break;
                }
                scriptEntry.getPlayer().getPlayerEntity().setPlayerWeather(WeatherType.DOWNFALL);
                break;
            }
            case THUNDER: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setThundering(true);
                    break;
                }
                scriptEntry.getPlayer().getPlayerEntity().setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Value {
        SUNNY,
        STORM,
        THUNDER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

