/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.tags.TagManager;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookScriptContainer
extends ScriptContainer {
    public BookScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public dItem getBookFrom() {
        return this.getBookFrom(null, null);
    }

    public dItem getBookFrom(dPlayer player, dNPC npc) {
        dItem stack = new dItem(Material.WRITTEN_BOOK);
        return this.writeBookTo(stack, player, npc);
    }

    public dItem writeBookTo(dItem book, dPlayer player, dNPC npc) {
        BookMeta bookInfo = (BookMeta)book.getItemStack().getItemMeta();
        if (this.contains("TITLE")) {
            String title = this.getString("TITLE");
            title = TagManager.tag(player, npc, title, false);
            bookInfo.setTitle(title);
        }
        if (this.contains("SIGNED") && this.getString("SIGNED").equalsIgnoreCase("false")) {
            book.getItemStack().setType(Material.BOOK_AND_QUILL);
        }
        if (this.contains("AUTHOR")) {
            String author = this.getString("AUTHOR");
            author = TagManager.tag(player, npc, author, false);
            bookInfo.setAuthor(author);
        }
        if (this.contains("TEXT")) {
            List<String> pages = this.getStringList("TEXT");
            for (String page : pages) {
                page = TagManager.tag(player, npc, page, false);
                bookInfo.addPage(new String[]{page});
            }
        }
        book.getItemStack().setItemMeta((ItemMeta)bookInfo);
        return book;
    }
}

