/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.LeatherColorer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    public static Map<dItem, dList> specialrecipesMap = new HashMap<dItem, dList>();
    dNPC npc = null;
    dPlayer player = null;
    public boolean bound = false;

    public ItemScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        ItemScriptHelper.item_scripts.put(this.getName(), this);
        if (this.contains("RECIPE")) {
            boolean usesItemscripts = false;
            List<String> recipeList = this.getStringList("RECIPE");
            for (int n = 0; n < recipeList.size(); ++n) {
                recipeList.set(n, TagManager.tag(this.player, this.npc, recipeList.get(n)));
            }
            dList ingredients = new dList();
            for (String recipeRow : recipeList) {
                String[] elements;
                for (String element : elements = recipeRow.split("\\|", 3)) {
                    ingredients.add(element.replaceAll("[iImM]@", ""));
                }
            }
            for (String ingredient : ingredients) {
                if (dMaterial.valueOf(ingredient) != null) continue;
                usesItemscripts = true;
            }
            if (usesItemscripts) {
                specialrecipesMap.put(this.getItemFrom(), ingredients);
            } else {
                ArrayList<dMaterial> recipe = new ArrayList<dMaterial>();
                for (String ingredient : ingredients) {
                    recipe.add(dMaterial.valueOf(ingredient));
                }
                ShapedRecipe shapedRecipe = new ShapedRecipe(this.getItemFrom().getItemStack());
                shapedRecipe.shape(new String[]{"abc", "def", "ghi"});
                char x = 'a';
                for (dMaterial material : recipe) {
                    if (!material.name().equals("AIR")) {
                        shapedRecipe.setIngredient(x, material.getMaterialData());
                    }
                    x = (char)(x + 1);
                }
                Bukkit.getServer().addRecipe((Recipe)shapedRecipe);
            }
        }
    }

    public dItem getItemFrom() {
        return this.getItemFrom(null, null);
    }

    public dItem getItemFrom(dPlayer player, dNPC npc) {
        dItem stack = null;
        try {
            if (this.contains("MATERIAL")) {
                String material = TagManager.tag(player, npc, this.getString("MATERIAL"));
                stack = dItem.valueOf(material);
            }
            if (stack == null) {
                return null;
            }
            ItemMeta meta = stack.getItemStack().getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            boolean hideLore = false;
            if (this.contains("NO_ID")) {
                hideLore = Boolean.valueOf(this.getString("NO_ID"));
            }
            if (!hideLore) {
                lore.add("\u00a70id:" + this.getName());
            }
            if (this.contains("DISPLAY NAME")) {
                String displayName = TagManager.tag(player, npc, this.getString("DISPLAY NAME"));
                meta.setDisplayName(displayName);
            }
            if (this.contains("BOUND")) {
                this.bound = Boolean.valueOf(TagManager.tag(player, npc, this.getString("BOUND")));
            }
            if (this.contains("LORE")) {
                for (String l : this.getStringList("LORE")) {
                    l = TagManager.tag(player, npc, l);
                    lore.add(l);
                }
            }
            meta.setLore(lore);
            stack.getItemStack().setItemMeta(meta);
            if (this.contains("ENCHANTMENTS")) {
                for (String enchantment : this.getStringList("ENCHANTMENTS")) {
                    enchantment = TagManager.tag(player, npc, enchantment);
                    try {
                        int level = 1;
                        if (enchantment.split(":").length > 1) {
                            level = Integer.valueOf(enchantment.split(":")[1]);
                            enchantment = enchantment.split(":")[0];
                        }
                        Enchantment ench = Enchantment.getByName((String)enchantment.toUpperCase());
                        stack.getItemStack().addUnsafeEnchantment(ench, level);
                    }
                    catch (Exception e) {
                        dB.echoError("While constructing '" + this.getName() + "', there has been a problem. '" + enchantment + "' is an invalid Enchantment!");
                    }
                }
            }
            if (this.contains("COLOR")) {
                String color = TagManager.tag(player, npc, this.getString("COLOR"));
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("BOOK")) {
                BookScriptContainer book = ScriptRegistry.getScriptContainerAs(this.getString("BOOK").replace("s@", ""), BookScriptContainer.class);
                stack = book.writeBookTo(stack, player, npc);
            }
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this item script!");
            dB.echoError(e);
            stack = null;
        }
        return stack;
    }

    public void setNPC(dNPC npc) {
        this.npc = npc;
    }

    public void setPlayer(dPlayer player) {
        this.player = player;
    }
}

