/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptQueue
implements Debuggable {
    private static final Map<Class<? extends ScriptQueue>, String> classNameCache = new WeakHashMap<Class<? extends ScriptQueue>, String>();
    protected static long total_queues = 0L;
    protected static Map<String, ScriptQueue> _queues = new ConcurrentHashMap<String, ScriptQueue>(8, 0.9f, 1);
    public String id;
    public boolean was_cleared = false;
    private final List<ScriptEntry> script_entries = new ArrayList<ScriptEntry>();
    private ScriptEntry lastEntryExecuted = null;
    private long delay_time = 0L;
    private final Map<String, String> definitions = new ConcurrentHashMap<String, String>(8, 0.9f, 1);
    private final Map<String, dObject> context = new ConcurrentHashMap<String, dObject>(8, 0.9f, 1);
    private final Map<String, ScriptEntry> held_entries = new ConcurrentHashMap<String, ScriptEntry>(8, 0.9f, 1);
    protected boolean is_started;
    protected boolean is_stopping = false;
    public boolean hasInjectedItems = false;

    public static String _getStats() {
        return "Total number of queues created: " + total_queues + ", currently active queues: " + _queues.size() + ".";
    }

    public static ScriptQueue _getExistingQueue(String id) {
        if (!ScriptQueue._queueExists(id)) {
            return null;
        }
        return _queues.get(id.toUpperCase());
    }

    public static String _getNextId() {
        return UUID.randomUUID().toString();
    }

    public static boolean _matchesType(String queue, Class type) {
        return ScriptQueue._queueExists(queue.toUpperCase()) && _queues.get(queue.toUpperCase()).getClass() == type;
    }

    public static Collection<ScriptQueue> _getQueues() {
        return _queues.values();
    }

    public static boolean _queueExists(String id) {
        return _queues.containsKey(id.toUpperCase());
    }

    protected ScriptQueue(String id) {
        this.id = id.toUpperCase();
        _queues.put(id.toUpperCase(), this);
        ++total_queues;
    }

    public boolean getWasCleared() {
        return this.was_cleared;
    }

    public ScriptEntry getHeldScriptEntry(String id) {
        return this.held_entries.get(id.toLowerCase());
    }

    public ScriptQueue holdScriptEntry(String id, ScriptEntry entry) {
        this.held_entries.put(id.toLowerCase(), entry);
        return this;
    }

    public dObject getContext(String id) {
        return this.context.get(id.toLowerCase());
    }

    public boolean hasContext(String id) {
        return this.context.containsKey(id.toLowerCase());
    }

    public void addContext(String id, dObject value) {
        if (value != null && id != null) {
            this.context.put(id.toLowerCase(), value);
        }
    }

    public Map<String, dObject> getAllContext() {
        return this.context;
    }

    public String getDefinition(String definition) {
        return this.definitions.get(definition.toLowerCase());
    }

    public boolean hasDefinition(String definition) {
        return this.definitions.containsKey(definition.toLowerCase());
    }

    public void addDefinition(String definition, String value) {
        this.definitions.put(definition.toLowerCase(), value);
    }

    public Map<String, String> getAllDefinitions() {
        return this.definitions;
    }

    public ScriptEntry getLastEntryExecuted() {
        return this.lastEntryExecuted;
    }

    public void clear() {
        this.was_cleared = true;
        this.script_entries.clear();
    }

    public void delayUntil(long delayTime) {
        this.delay_time = delayTime;
    }

    protected abstract void onStart();

    public void start() {
        boolean is_delayed;
        if (this.is_started) {
            return;
        }
        this.is_started = true;
        boolean bl = is_delayed = this.delay_time > System.currentTimeMillis();
        if (is_delayed) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    ScriptQueue.this.onStart();
                }
            }, (this.delay_time - System.currentTimeMillis()) / 1000L * 20L);
        } else {
            this.onStart();
        }
        Class<?> clazz = this.getClass();
        String name = classNameCache.get(clazz);
        if (name == null) {
            name = clazz.getSimpleName();
            classNameCache.put(clazz, name);
        }
        if (is_delayed) {
            dB.echoDebug((Debuggable)this, "Delaying " + name + " '" + this.id + "'" + " for '" + new Duration((this.delay_time - System.currentTimeMillis()) / 1000L * 20L).identify() + "'.");
        } else {
            dB.echoDebug((Debuggable)this, "Starting " + name + " '" + this.id + "'");
        }
    }

    protected abstract void onStop();

    public void stop() {
        if (!this.is_stopping) {
            ArrayList entries;
            this.is_stopping = true;
            List<Object> list = entries = this.lastEntryExecuted != null && this.lastEntryExecuted.getScript() != null ? this.lastEntryExecuted.getScript().getContainer().getEntries(this.lastEntryExecuted.getPlayer(), this.lastEntryExecuted.getNPC(), "on queue completes") : new ArrayList();
            if (!entries.isEmpty()) {
                this.script_entries.addAll(entries);
                dB.echoDebug((Debuggable)this, "Finishing up queue " + this.id + "...");
            } else {
                _queues.remove(this.id);
                dB.echoDebug((Debuggable)this, "Completing queue " + this.id + "...");
                this.is_started = false;
                this.onStop();
            }
        } else {
            _queues.remove(this.id);
            dB.echoDebug((Debuggable)this, "Completing queue " + this.id + "...");
            this.is_started = false;
            this.onStop();
        }
    }

    public void setLastEntryExecuted(ScriptEntry entry) {
        this.lastEntryExecuted = entry;
    }

    protected abstract boolean shouldRevolve();

    protected void revolve() {
        if (this.script_entries.isEmpty()) {
            this.stop();
            return;
        }
        if (!this.shouldRevolve()) {
            return;
        }
        DenizenAPI.getCurrentInstance().getScriptEngine().revolve(this);
        if (this.script_entries.isEmpty()) {
            this.stop();
        }
    }

    public ScriptEntry getNext() {
        if (!this.script_entries.isEmpty()) {
            return this.script_entries.remove(0);
        }
        return null;
    }

    public ScriptQueue addEntries(List<ScriptEntry> entries) {
        this.script_entries.addAll(entries);
        return this;
    }

    public ScriptQueue injectEntries(List<ScriptEntry> entries, int position) {
        if (position > this.script_entries.size() || position < 0) {
            position = 1;
        }
        if (this.script_entries.size() == 0) {
            position = 0;
        }
        this.script_entries.addAll(position, entries);
        this.hasInjectedItems = true;
        return this;
    }

    public boolean removeEntry(int position) {
        if (this.script_entries.size() < position) {
            return false;
        }
        this.script_entries.remove(position);
        return true;
    }

    public ScriptEntry getEntry(int position) {
        if (this.script_entries.size() < position) {
            return null;
        }
        return this.script_entries.get(position);
    }

    public ScriptQueue injectEntry(ScriptEntry entry, int position) {
        if (position > this.script_entries.size() || position < 0) {
            position = 1;
        }
        if (this.script_entries.size() == 0) {
            position = 0;
        }
        this.script_entries.add(position, entry);
        this.hasInjectedItems = true;
        return this;
    }

    public int getQueueSize() {
        return this.script_entries.size();
    }

    @Override
    public boolean shouldDebug() throws Exception {
        return this.lastEntryExecuted != null ? this.lastEntryExecuted.shouldDebug() : this.script_entries.get(0).shouldDebug();
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.lastEntryExecuted != null ? this.lastEntryExecuted.getScript().getName().equalsIgnoreCase(criteria.replace("s@", "")) : this.script_entries.get(0).getScript().getName().equalsIgnoreCase(criteria.replace("s@", ""));
    }
}

