/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrigger
implements RegistrationableInstance {
    protected String name;

    @Override
    public AbstractTrigger as(String triggerName) {
        this.name = triggerName.toUpperCase();
        DenizenAPI.getCurrentInstance().getTriggerRegistry().register(triggerName, this);
        this.onEnable();
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public AbstractTrigger activate() {
        return this;
    }

    public boolean parse(dNPC npc, dPlayer player, InteractScriptContainer script) {
        return this.parse(npc, player, script, null, null);
    }

    public boolean parse(dNPC npc, dPlayer player, InteractScriptContainer script, String id) {
        return this.parse(npc, player, script, id, null);
    }

    public boolean parse(dNPC npc, dPlayer player, InteractScriptContainer script, String id, Map<String, dObject> context) {
        if (npc == null || player == null || script == null) {
            return false;
        }
        List<ScriptEntry> entries = script.getEntriesFor(this.getClass(), player, npc, id);
        if (entries.isEmpty()) {
            return false;
        }
        dB.echoDebug(script, dB.DebugElement.Header, "Parsing " + this.name + " trigger: " + npc.getName() + "/" + player.getName());
        TimedQueue queue = TimedQueue.getQueue(ScriptQueue._getNextId());
        queue.addEntries(entries);
        if (context != null) {
            for (Map.Entry<String, dObject> entry : context.entrySet()) {
                queue.addContext(entry.getKey(), entry.getValue());
            }
        }
        queue.start();
        return true;
    }

    public Set<NPC> getActiveNPCsWithinRangeWithTrigger(Location location, int maxRange) {
        HashSet<NPC> closestNPCs = new HashSet<NPC>();
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned() || !npc.getEntity().getLocation().getWorld().equals(location.getWorld()) || !(npc.getEntity().getLocation().distance(location) < (double)maxRange) || !npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }
}

