/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.text.DecimalFormat;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.bukkit.ReplaceableTagEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@Deprecated
public class FlagTags
implements Listener {
    Denizen denizen;

    public FlagTags(Denizen denizen) {
        this.denizen = denizen;
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void flagTag(ReplaceableTagEvent event) {
        if (!event.matches("FLAG")) {
            return;
        }
        if (!event.hasValue()) {
            return;
        }
        String flagName = event.getValue().split(":").length > 1 ? event.getValue().split(":")[0].toUpperCase() : event.getValue().toUpperCase();
        String flagFallback = event.getAlternative() != null ? event.getAlternative() : "EMPTY";
        int index = -1;
        ReplaceType replaceType = ReplaceType.ASSTRING;
        if (flagName.contains(".")) {
            try {
                int replaceTypeIndex = flagName.split("\\.").length - 1;
                replaceType = ReplaceType.valueOf(flagName.split("\\.")[replaceTypeIndex].replace("_", "").toUpperCase());
                flagName = flagName.replace("." + flagName.split("\\.")[replaceTypeIndex], "");
            }
            catch (Exception e) {
                replaceType = ReplaceType.ASSTRING;
            }
        }
        if (event.hasValueContext()) {
            try {
                index = Integer.valueOf(event.getValueContext());
            }
            catch (NumberFormatException e) {
                index = -1;
            }
        }
        if (event.getType().toUpperCase().startsWith("G")) {
            if (!this.denizen.flagManager().getGlobalFlag(flagName).get(index).isEmpty()) {
                FlagManager.Flag flag = this.denizen.flagManager().getGlobalFlag(flagName);
                event.setReplaced(this.getReplaceable(flag, flag.get(index), replaceType));
            }
        } else if (event.getType().toUpperCase().startsWith("D") || event.getType().toUpperCase().startsWith("N")) {
            if (!this.denizen.flagManager().getNPCFlag(event.getNPC().getId(), flagName).get(index).isEmpty()) {
                FlagManager.Flag flag = this.denizen.flagManager().getNPCFlag(event.getNPC().getId(), flagName);
                event.setReplaced(this.getReplaceable(flag, flag.get(index), replaceType));
            }
        } else if (event.getType().toUpperCase().startsWith("P")) {
            String name = null;
            if (event.getPlayer() != null) {
                name = event.getPlayer().getName();
            }
            if (name == null) {
                return;
            }
            if (this.denizen.flagManager().getPlayerFlag(name, flagName).get(index).isEmpty()) {
                if (replaceType.toString().equals("ISEXPIRED")) {
                    event.setReplaced("true");
                }
            } else {
                FlagManager.Flag flag = this.denizen.flagManager().getPlayerFlag(name, flagName);
                event.setReplaced(this.getReplaceable(flag, flag.get(index), replaceType));
            }
        }
    }

    private String getReplaceable(FlagManager.Flag flag, FlagManager.Value value, ReplaceType replaceType) {
        switch (replaceType) {
            case ASINT: {
                return String.valueOf(value.asInteger());
            }
            case ASDOUBLE: {
                return String.valueOf(value.asDouble());
            }
            case ABS: {
                return String.valueOf(Math.abs(value.asDouble()));
            }
            case ASSTRING: {
                return value.asString();
            }
            case ASLIST: {
                return String.valueOf(value.asList());
            }
            case ASPLAYERLIST: {
                return String.valueOf(value.asList("p@"));
            }
            case ASNPCLIST: {
                return String.valueOf(value.asList("n@"));
            }
            case ASCSLIST: {
                return String.valueOf(value.asCommaSeparatedList());
            }
            case ASMONEY: {
                DecimalFormat d = new DecimalFormat("0.00");
                return String.valueOf(d.format(value.asDouble()));
            }
            case LENGTH: {
                return String.valueOf(value.asString().length());
            }
            case SIZE: {
                return String.valueOf(value.asSize());
            }
            case ISEXPIRED: {
                return String.valueOf(flag.checkExpired());
            }
            case EXPIRATION: {
                return String.valueOf(flag.expirationTime());
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReplaceType {
        LENGTH,
        SIZE,
        ASSTRING,
        ABS,
        ASINT,
        ASDOUBLE,
        ASLIST,
        ASMONEY,
        ASPLAYERLIST,
        ASNPCLIST,
        ASCSLIST,
        ISEXPIRED,
        EXPIRATION;

    }
}

