/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerFishesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerFishesScriptEvent instance;
    public dEntity hook;
    public Element state;
    public dEntity entity;
    public dItem item;
    public PlayerFishEvent event;

    public PlayerFishesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player fishes");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String fish = CoreUtilities.getXthArg(2, lower);
        if (this.entity != null && fish.length() > 0 && !this.entity.matchesEntity(fish)) {
            return false;
        }
        List<String> data = CoreUtilities.split(lower, ' ');
        for (int index = 0; index < data.size(); ++index) {
            if (!data.get(index).equals("while") || data.get(index + 1).equalsIgnoreCase(this.state.asString())) continue;
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.hook.getLocation());
    }

    @Override
    public String getName() {
        return "PlayerFishes";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerFishEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : (dEntity.isPlayer(this.event.getCaught()) ? dEntity.getPlayerFrom(this.event.getCaught()) : null), dEntity.isCitizensNPC((Entity)this.event.getPlayer()) ? dEntity.getNPCFrom((Entity)this.event.getPlayer()) : (dEntity.isCitizensNPC(this.event.getCaught()) ? dEntity.getNPCFrom(this.event.getCaught()) : null));
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("hook", this.hook);
        context.put("state", this.state);
        if (this.entity != null) {
            context.put("entity", this.entity.getDenizenObject());
        }
        if (this.item != null) {
            context.put("item", this.item);
        }
        return context;
    }

    @EventHandler
    public void onPlayerFishes(PlayerFishEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.hook = new dEntity((Entity)event.getHook());
        this.state = new Element(event.getState().name());
        this.item = null;
        this.entity = null;
        if (event.getCaught() != null) {
            this.entity = new dEntity(event.getCaught());
            if (event.getCaught() instanceof Item) {
                this.item = new dItem(((Item)event.getCaught()).getItemStack());
            }
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

