/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerPlacesHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPlacesHangingScriptEvent instance;
    public dEntity hanging;
    public dList cuboids;
    public dLocation location;
    public HangingPlaceEvent event;

    public PlayerPlacesHangingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player places");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String hangCheck = CoreUtilities.getXthArg(2, lower);
        if (!this.hanging.matchesEntity(hangCheck)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    @Override
    public String getName() {
        return "PlayerPlacesHanging";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        HangingPlaceEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("hanging", this.hanging);
        context.put("cuboids", this.cuboids);
        context.put("location", this.location);
        return context;
    }

    @EventHandler
    public void pnPlayerPlacesHanging(HangingPlaceEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.hanging = new dEntity((Entity)event.getEntity());
        this.location = new dLocation(event.getBlock().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

