/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import java.util.HashMap;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightningStrikesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LightningStrikesScriptEvent instance;
    public dEntity lightning;
    public dLocation location;
    public LightningStrikeEvent event;

    public LightningStrikesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("lightning strikes");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return this.runInCheck(scriptContainer, s, CoreUtilities.toLowerCase(s), this.location);
    }

    @Override
    public String getName() {
        return "LightningStrikes";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        LightningStrikeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("lightning", this.lightning);
        context.put("world", new dWorld(this.location.getWorld()));
        context.put("location", this.location);
        return context;
    }

    @EventHandler
    public void onLightningStrikes(LightningStrikeEvent event) {
        this.lightning = new dEntity((Entity)event.getLightning());
        this.location = new dLocation(event.getLightning().getLocation());
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

