/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnChangeScriptEvent
extends ScriptEvent
implements Listener {
    public static SpawnChangeScriptEvent instance;
    public dWorld world;
    public dLocation old_location;
    public dLocation new_location;
    public SpawnChangeEvent event;

    public SpawnChangeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("spawn changes");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    @Override
    public String getName() {
        return "SpawnChange";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        SpawnChangeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("world", this.world);
        context.put("old_location", this.old_location);
        context.put("new_location", this.new_location);
        return context;
    }

    @EventHandler
    public void onSpawnChange(SpawnChangeEvent event) {
        this.world = new dWorld(event.getWorld());
        this.old_location = new dLocation(event.getPreviousLocation());
        this.new_location = new dLocation(event.getWorld().getSpawnLocation());
        this.event = event;
        this.fire();
    }
}

