/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.List;
import net.aufdemrand.denizen.utilities.BiomeNMS;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class dBiome
implements dObject,
Adjustable {
    private BiomeNMS biome;
    String prefix = "biome";

    public static dBiome valueOf(String string) {
        return dBiome.valueOf(string, null);
    }

    @Fetchable(value="b")
    public static dBiome valueOf(String string, TagContext context) {
        if (string.startsWith("b@")) {
            string = string.substring(2);
        }
        for (Biome biome : Biome.values()) {
            if (!biome.name().equalsIgnoreCase(string)) continue;
            return new dBiome(biome);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("b@")) {
            arg = arg.substring(2);
        }
        for (Biome b : Biome.values()) {
            if (!b.name().equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public dBiome(Biome biome) {
        this.biome = new BiomeNMS(biome);
    }

    public BiomeNMS getBiome() {
        return this.biome;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getObjectType() {
        return "Biome";
    }

    public String identify() {
        return "b@" + this.biome.getName().toLowerCase();
    }

    public String identifySimple() {
        return this.identify();
    }

    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("downfall_type")) {
            return new Element(CoreUtilities.toLowerCase(this.biome.getDownfallType().name())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("humidity")) {
            return new Element(Float.valueOf(this.biome.getHumidity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("temperature")) {
            return new Element(Float.valueOf(this.biome.getTemperature())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawnable_entities")) {
            List<EntityType> entityTypes;
            attribute = attribute.fulfill(1);
            boolean hasAttribute = true;
            if (attribute.startsWith("ambient")) {
                entityTypes = this.biome.getAmbientEntities();
            } else if (attribute.startsWith("creatures")) {
                entityTypes = this.biome.getCreatureEntities();
            } else if (attribute.startsWith("monsters")) {
                entityTypes = this.biome.getMonsterEntities();
            } else if (attribute.startsWith("water")) {
                entityTypes = this.biome.getWaterEntities();
            } else {
                entityTypes = this.biome.getAllEntities();
                hasAttribute = false;
            }
            dList list = new dList();
            for (EntityType entityType : entityTypes) {
                list.add(entityType.name());
            }
            return list.getAttribute(hasAttribute ? attribute.fulfill(1) : attribute);
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to a biome!");
    }

    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("humidity") && mechanism.requireFloat()) {
            this.biome.setHumidity(value.asFloat());
        }
        if (mechanism.matches("temperature") && mechanism.requireFloat()) {
            this.biome.setTemperature(value.asFloat());
        }
    }
}

