/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.entity.RabbitType;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.DyeColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Wolf;

public class EntityColor
implements Property {
    dEntity colored;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        EntityType type = ((dEntity)entity).getBukkitEntityType();
        return type == EntityType.SHEEP || type == EntityType.HORSE || type == EntityType.WOLF || type == EntityType.OCELOT || type == EntityType.RABBIT;
    }

    public static EntityColor getFrom(dObject entity) {
        if (!EntityColor.describes(entity)) {
            return null;
        }
        return new EntityColor((dEntity)entity);
    }

    private EntityColor(dEntity entity) {
        this.colored = entity;
    }

    private String getColor() {
        EntityType type = this.colored.getBukkitEntityType();
        if (type == EntityType.HORSE) {
            return ((Horse)this.colored.getBukkitEntity()).getColor().name() + "|" + ((Horse)this.colored.getBukkitEntity()).getStyle().name() + "|" + ((Horse)this.colored.getBukkitEntity()).getVariant().name();
        }
        if (type == EntityType.SHEEP) {
            return ((Sheep)this.colored.getBukkitEntity()).getColor().name();
        }
        if (type == EntityType.WOLF) {
            return ((Wolf)this.colored.getBukkitEntity()).getCollarColor().name();
        }
        if (type == EntityType.OCELOT) {
            return ((Ocelot)this.colored.getBukkitEntity()).getCatType().name();
        }
        if (type == EntityType.RABBIT) {
            return RabbitType.getRabbitType((Rabbit)this.colored.getBukkitEntity()).name();
        }
        return null;
    }

    public String getPropertyString() {
        return CoreUtilities.toLowerCase(this.getColor());
    }

    public String getPropertyId() {
        return "color";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("color")) {
            return new Element(this.getColor().toLowerCase()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("color")) {
            EntityType type = this.colored.getBukkitEntityType();
            if (type == EntityType.HORSE) {
                dList horse_info = mechanism.getValue().asType(dList.class);
                if (horse_info.size() > 0 && new Element((String)horse_info.get(0)).matchesEnum((Enum[])Horse.Color.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setColor(Horse.Color.valueOf((String)((String)horse_info.get(0)).toUpperCase()));
                }
                if (horse_info.size() > 1 && new Element((String)horse_info.get(1)).matchesEnum((Enum[])Horse.Style.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setStyle(Horse.Style.valueOf((String)((String)horse_info.get(1)).toUpperCase()));
                }
                if (horse_info.size() > 2 && new Element((String)horse_info.get(2)).matchesEnum((Enum[])Horse.Variant.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setVariant(Horse.Variant.valueOf((String)((String)horse_info.get(2)).toUpperCase()));
                }
            } else if (type == EntityType.SHEEP && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Sheep)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.WOLF && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Wolf)this.colored.getBukkitEntity()).setCollarColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.OCELOT && mechanism.getValue().matchesEnum((Enum[])Ocelot.Type.values())) {
                ((Ocelot)this.colored.getBukkitEntity()).setCatType(Ocelot.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.RABBIT && mechanism.getValue().matchesEnum(RabbitType.values())) {
                RabbitType.setRabbitType((Rabbit)this.colored.getBukkitEntity(), RabbitType.valueOf(mechanism.getValue().asString().toUpperCase()));
            }
        }
    }
}

