/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.tags.core.ServerTags;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class AdjustCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("object")) {
                scriptEntry.addObject("object", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("mechanism")) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new Element(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.asElement());
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                scriptEntry.addObject("mechanism_value", new Element(""));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("object")) {
            throw new InvalidArgumentsException("You must specify an object!");
        }
        if (!scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("You must specify a mechanism!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element mechanism = scriptEntry.getElement("mechanism");
        Element value = scriptEntry.getElement("mechanism_value");
        dB.report(scriptEntry, this.getName(), scriptEntry.getElement("object").debug() + mechanism.debug() + value.debug());
        dList objects = dList.valueOf(scriptEntry.getElement("object").asString());
        dList result = new dList();
        for (String object : objects) {
            if (object.equalsIgnoreCase("server")) {
                ServerTags.adjustServer(new Mechanism(mechanism, value));
                continue;
            }
            Class object_class = ObjectFetcher.getObjectClass(object.split("@")[0]);
            if (object_class == null) {
                dB.echoError("Unfetchable object found '" + object + "'!");
                return;
            }
            if (!ObjectFetcher.checkMatch(object_class, object)) {
                throw new CommandExecutionException('\'' + object + "' is returning null.");
            }
            Object fetched = ObjectFetcher.getObjectFrom(object_class, object);
            if (fetched == null || !(fetched instanceof Adjustable)) {
                dB.echoError("'" + object + "' is not adjustable.");
                return;
            }
            ((Adjustable)fetched).adjust(new Mechanism(mechanism, value));
            if (objects.size() == 1) {
                scriptEntry.addObject("result", fetched);
            }
            result.add(fetched.identify());
        }
        scriptEntry.addObject("result_list", result);
    }
}

