/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.npc.traits.HungerTrait;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class FeedCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrimitive(aH.PrimitiveType.Integer) && !scriptEntry.hasObject("amount")) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(dPlayer.class) && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
                scriptEntry.addObject("targetplayer", arg.asType(dPlayer.class));
                continue;
            }
            if (arg.matchesArgumentType(dNPC.class) && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
                scriptEntry.addObject("targetnpc", arg.asType(dNPC.class));
                continue;
            }
            if (arg.matches("NPC") && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc") && ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
                scriptEntry.addObject("targetnpc", ((BukkitScriptEntryData)scriptEntry.entryData).getNPC());
                continue;
            }
            if (arg.matches("PLAYER") && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc") && ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer()) {
                scriptEntry.addObject("targetplayer", ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
            if (((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer()) {
                scriptEntry.addObject("targetplayer", ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer());
            } else if (((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
                scriptEntry.addObject("targetnpc", ((BukkitScriptEntryData)scriptEntry.entryData).getNPC());
            } else {
                throw new InvalidArgumentsException("Must specify a player!");
            }
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new Element(9999));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dPlayer player = (dPlayer)scriptEntry.getObject("targetplayer");
        dNPC npc = (dNPC)scriptEntry.getObject("targetnpc");
        Element amount = scriptEntry.getElement("amount");
        dB.report(scriptEntry, this.getName(), (player == null ? "" : player.debug()) + (npc == null ? "" : npc.debug()) + amount.debug());
        if (npc != null) {
            if (!npc.getCitizen().hasTrait(HungerTrait.class)) {
                dB.echoError(scriptEntry.getResidingQueue(), "This NPC does not have the HungerTrait enabled! Use /trait hunger");
                return;
            }
            ((HungerTrait)npc.getCitizen().getTrait(HungerTrait.class)).feed(amount.asInt());
        } else if (player != null) {
            if (95999 - player.getPlayerEntity().getFoodLevel() < amount.asInt()) {
                amount = new Element(95999 - player.getPlayerEntity().getFoodLevel());
            }
            player.getPlayerEntity().setFoodLevel(player.getPlayerEntity().getFoodLevel() + amount.asInt());
        } else {
            dB.echoError(scriptEntry.getResidingQueue(), "No target?");
        }
    }
}

