/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.events.entity.EntityDespawnScriptEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.world.DenizenWorldAccess;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.minecraft.server.v1_8_R3.IWorldAccess;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class EntityScriptHelper
implements Listener {
    static HashMap<UUID, String> entities = new HashMap();
    private static final Field iWorldAccessList;
    private static final Map<org.bukkit.World, DenizenWorldAccess> worlds;

    public EntityScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        EntityDespawnScriptEvent.instance.entity = new dEntity((Entity)event.getEntity());
        EntityDespawnScriptEvent.instance.cause = new Element("DEATH");
        EntityDespawnScriptEvent.instance.cancelled = false;
        EntityDespawnScriptEvent.instance.fire();
        EntityScriptHelper.unlinkEntity((Entity)event.getEntity());
    }

    public static void linkWorld(org.bukkit.World world) {
        DenizenWorldAccess denizenWorldAccess = new DenizenWorldAccess();
        worlds.put(world, denizenWorldAccess);
        ((CraftWorld)world).getHandle().addIWorldAccess((IWorldAccess)denizenWorldAccess);
    }

    public static void unlinkWorld(org.bukkit.World world) {
        try {
            ((List)iWorldAccessList.get(((CraftWorld)world).getHandle())).remove(worlds.get(world));
            worlds.remove(world);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        EntityScriptHelper.linkWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldUnload(WorldUnloadEvent event) {
        EntityScriptHelper.unlinkWorld(event.getWorld());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (Entity ent : event.getChunk().getEntities()) {
            if (ent instanceof LivingEntity && !((LivingEntity)ent).getRemoveWhenFarAway()) continue;
            EntityDespawnScriptEvent.instance.entity = new dEntity(ent);
            EntityDespawnScriptEvent.instance.cause = new Element("CHUNK_UNLOAD");
            EntityDespawnScriptEvent.instance.cancelled = false;
            EntityDespawnScriptEvent.instance.fire();
            EntityScriptHelper.unlinkEntity(ent);
        }
    }

    public static void reloadEntities() {
        entities.clear();
        ConfigurationSection entity_scripts = DenizenAPI.getCurrentInstance().getEntities().getConfigurationSection("entities.scripts");
        if (entity_scripts == null) {
            return;
        }
        for (String Path2 : entity_scripts.getKeys(false)) {
            UUID id = UUID.fromString(Path2);
            String scriptname = entity_scripts.getString(Path2 + ".scriptname");
            entities.put(id, scriptname);
        }
    }

    public static void saveEntities() {
        FileConfiguration entityScripts = DenizenAPI.getCurrentInstance().getEntities();
        entityScripts.set("entities.scripts", null);
        for (Map.Entry<UUID, String> entry : entities.entrySet()) {
            entityScripts.set("entities.scripts." + entry.getKey() + ".scriptname", (Object)entry.getValue());
        }
    }

    public static boolean entityHasScript(Entity ent) {
        return EntityScriptHelper.getEntityScript(ent) != null;
    }

    public static String getEntityScript(Entity ent) {
        if (ent == null) {
            return null;
        }
        return EntityScriptHelper.getEntityScript(ent.getUniqueId());
    }

    public static String getEntityScript(UUID entID) {
        if (entID == null) {
            return null;
        }
        return entities.get(entID);
    }

    public static void setEntityScript(Entity ent, String script) {
        if (ent == null || ent.getUniqueId() == null || script == null) {
            return;
        }
        entities.put(ent.getUniqueId(), script);
    }

    public static void unlinkEntity(Entity ent) {
        if (ent == null || ent.getUniqueId() == null) {
            return;
        }
        entities.remove(ent.getUniqueId());
        FlagManager.clearEntityFlags(new dEntity(ent));
    }

    static {
        worlds = new HashMap<org.bukkit.World, DenizenWorldAccess>();
        Field field = null;
        try {
            field = World.class.getDeclaredField("u");
            field.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        iWorldAccessList = field;
    }
}

