/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets.intercept;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.scripts.commands.server.ExecuteCommand;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.PlayerProfileEditor;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.EntityFakePlayer;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.NBTTagList;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutChat;
import net.minecraft.server.v1_8_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_8_R3.PacketPlayOutWindowItems;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PacketOutHandler {
    private static final Field set_slot_windowId;
    private static final Field set_slot_slotId;
    private static final Field set_slot_itemStack;
    private static final Field window_items_windowId;
    private static final Field window_items_itemStackArray;
    private static final Field named_spawn_entityId;
    private static final Field named_spawn_entityUUID;

    public static boolean handle(final EntityPlayer player, Packet packet) {
        try {
            if (packet instanceof PacketPlayOutChat) {
                if (ExecuteCommand.silencedPlayers.contains(player.getUniqueID())) {
                    return true;
                }
            } else if (packet instanceof PacketPlayOutSetSlot) {
                PacketPlayOutSetSlot ssPacket = (PacketPlayOutSetSlot)packet;
                ItemStack itemStack = (ItemStack)set_slot_itemStack.get(ssPacket);
                set_slot_itemStack.set(ssPacket, PacketOutHandler.removeItemScriptLore(itemStack));
            } else if (packet instanceof PacketPlayOutWindowItems) {
                PacketPlayOutWindowItems wiPacket = (PacketPlayOutWindowItems)packet;
                ItemStack[] itemStacks = (ItemStack[])window_items_itemStackArray.get(wiPacket);
                for (int i = 0; i < itemStacks.length; ++i) {
                    itemStacks[i] = PacketOutHandler.removeItemScriptLore(itemStacks[i]);
                }
                window_items_itemStackArray.set(wiPacket, itemStacks);
            } else if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                PacketPlayOutNamedEntitySpawn nesPacket = (PacketPlayOutNamedEntitySpawn)packet;
                UUID entityUUID = (UUID)named_spawn_entityUUID.get(nesPacket);
                final Entity entity = ((WorldServer)player.getWorld()).getEntity(entityUUID);
                if (entity instanceof EntityFakePlayer) {
                    player.playerConnection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{(EntityFakePlayer)entity}));
                    Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                        public void run() {
                            player.playerConnection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{(EntityFakePlayer)entity}));
                        }
                    }, 5L);
                }
            } else if (packet instanceof PacketPlayOutPlayerInfo) {
                PlayerProfileEditor.updatePlayerProfiles((PacketPlayOutPlayerInfo)packet);
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return false;
    }

    private static ItemStack removeItemScriptLore(ItemStack itemStack) throws Exception {
        if (itemStack != null && itemStack.hasTag() && !itemStack.getTag().isEmpty()) {
            NBTTagCompound tag = itemStack.getTag();
            NBTTagCompound display = tag.getCompound("display");
            NBTTagList lore = (NBTTagList)display.get("Lore");
            if (lore == null || lore.isEmpty()) {
                return itemStack;
            }
            String hash = null;
            for (int i = 0; i < lore.size(); ++i) {
                String line = lore.getString(i);
                if (!line.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                hash = line;
                lore.a(i);
                break;
            }
            if (hash != null) {
                display.set("Lore", (NBTBase)lore);
                tag.set("display", (NBTBase)display);
                tag.setString("Denizen Item Script", hash);
                itemStack.setTag(tag);
            }
        }
        return itemStack;
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutSetSlot.class);
        set_slot_windowId = fields.get("a");
        set_slot_slotId = fields.get("b");
        set_slot_itemStack = fields.get("c");
        fields = PacketHelper.registerFields(PacketPlayOutWindowItems.class);
        window_items_windowId = fields.get("a");
        window_items_itemStackArray = fields.get("b");
        fields = PacketHelper.registerFields(PacketPlayOutNamedEntitySpawn.class);
        named_spawn_entityId = fields.get("a");
        named_spawn_entityUUID = fields.get("b");
    }
}

