/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class Settings {
    public static boolean useDefaultScriptPath() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Scripts location.Use default script folder", true);
    }

    public static String getAlternateScriptPath() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Scripts location.Alternative folder path", "plugins/Denizen");
    }

    public static boolean showDebug() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Show", true);
    }

    public static boolean overrideHelp() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Override help", true);
    }

    public static int consoleWidth() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Debug.Console width", 60);
    }

    public static int trimLength() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Debug.Trim length", 512);
    }

    public static boolean showExHelp() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Ex command help", true);
    }

    public static boolean allowConsoleRedirection() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Allow console redirection", false);
    }

    public static boolean canRecordStats() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Stats", true);
    }

    public static String scriptQueueSpeed() {
        String delay = DenizenAPI.getCurrentInstance().getConfig().getString("Scripts.Queue speed", "0.5s");
        try {
            if (Duration.valueOf(delay).getTicks() < 1L) {
                delay = "1t";
            }
        }
        catch (Exception e) {
            delay = "0.5s";
        }
        return delay;
    }

    public static boolean healthTraitEnabledByDefault() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Enabled", false);
    }

    public static boolean healthTraitRespawnEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Respawn.Enabled", true);
    }

    public static boolean healthTraitAnimatedDeathEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Animated death.Enabled", true);
    }

    public static String healthTraitRespawnDelay() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Traits.Health.Respawn.Delay", "10s");
    }

    public static boolean triggerEnabled(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Enabled", true);
    }

    public static double triggerDefaultCooldown(String triggerName) {
        return Duration.valueOf(DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Cooldown", "5s")).getSeconds();
    }

    public static double triggerDefaultRange(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Range", -1.0);
    }

    public static String triggerDefaultCooldownType(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Cooldown Type", "Player");
    }

    public static boolean clickTriggerAllowsLeftClick() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Click.Allows left click", false);
    }

    public static String engageTimeoutInSeconds() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Engage.Timeout", "150s");
    }

    public static int whileMaxLoops() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Commands.While.Max loops", 10000);
    }

    public static boolean allowWebget() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Webget.Allow", false);
    }

    public static boolean allowStupids() {
        return Settings.allowStupid1() && Settings.allowStupid2() && Settings.allowStupid3();
    }

    public static boolean allowStupid1() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.General.Allow stupid file abuse you moron dont enable this", false);
    }

    public static boolean allowStupid2() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.General.are you sure", false);
    }

    public static boolean allowStupid3() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.General.are you absolutely seriously sure dont enable this", false);
    }

    public static boolean allowStupidx() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.General.This one dont touch", false);
    }

    public static boolean allowFilecopy() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Filecopy.Allow copying files", true);
    }

    public static boolean allowDelete() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Delete.Allow file deletion", true);
    }

    public static boolean allowServerStop() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Restart.Allow server stop", false);
    }

    public static boolean allowServerRestart() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Restart.Allow server restart", true);
    }

    public static boolean allowRunningJava() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Java.Allow running java", false);
    }

    public static boolean allowLogging() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Log.Allow logging", true);
    }

    public static boolean allowStrangeYAMLSaves() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Commands.Yaml.Allow saving outside folder", false);
    }

    public static String chatMultipleTargetsFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Chat.Options.Multiple targets format", "%target%, %target%, %target%, and others");
    }

    public static double chatBystandersRange() {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Commands.Chat.Options.Range for bystanders", 5.0);
    }

    public static String chatNoTargetFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Chat.Formats.No target", "[<def[talker].name>]: <def[message]>");
    }

    public static String chatToTargetFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Chat.Formats.To target", "[<def[talker].name>] -> You: <def[message]>");
    }

    public static String chatWithTargetToBystandersFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Chat.Formats.With target to bystanders", "[<def[talker].name>] -> <def[target].name>: <def[message]>");
    }

    public static String chatWithTargetsToBystandersFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Chat.Formats.With targets to bystanders", "[<def[talker].name>] -> [<def[targets]>]: <def[message]>");
    }

    public static boolean chatAsynchronous() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Use asynchronous event", false);
    }

    public static String chatToNpcFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to NPC", "You -> <npc.name.nickname>: <text>");
    }

    public static String chatToNpcOverheardFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to NPC overheard", "<player.name> -> <npc.name.nickname>: <text>");
    }

    public static double chatToNpcOverhearingRange() {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers.Chat.Overhearing range", 4.0);
    }

    public static boolean chatMustSeeNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must be able to see NPC", true);
    }

    public static boolean chatMustLookAtNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must be looking in direction of NPC", true);
    }

    public static boolean chatGloballyIfFailedChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears globally.If triggers failed", false);
    }

    public static boolean chatGloballyIfNoChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears globally.If triggers missing", true);
    }

    public static boolean chatGloballyIfUninteractable() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears globally.If NPC uninteractable", true);
    }

    public static boolean worldScriptChatEventAsynchronous() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Scripts.World.Events.On player chats.Use asynchronous event", false);
    }

    public static Duration worldScriptTimeEventFrequency() {
        return Duration.valueOf(DenizenAPI.getCurrentInstance().getConfig().getString("Scripts.World.Events.On time changes.Frequency of check", "250t"));
    }

    public static int blockTagsMaxBlocks() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Tags.Block tags.Max blocks", 1000000);
    }

    public static int pathfindingMaxDistance() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Tags.Path finding.Max distance", 100);
    }

    public static int chatHistoryMaxMessages() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Tags.Chat history.Max messages", 10);
    }

    public static int tagTimeout() {
        return DenizenAPI.getCurrentInstance().getConfig().getInt("Tags.Timeout", 10);
    }

    public static boolean packetInterception() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Packets.Interception", true);
    }
}

