/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.inventory;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class InventoryHolder
implements Property {
    dInventory inventory;
    dObject holder;

    public static boolean describes(dObject inventory) {
        return inventory instanceof dInventory;
    }

    public static InventoryHolder getFrom(dObject inventory) {
        if (!InventoryHolder.describes(inventory)) {
            return null;
        }
        return new InventoryHolder((dInventory)inventory);
    }

    public InventoryHolder(dInventory inventory) {
        this.inventory = inventory;
        this.holder = this.getHolder();
    }

    public dObject getHolder() {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        if (this.inventory.getIdType() != null && (this.inventory.getIdType().equals("player") || this.inventory.getIdType().equals("enderchest"))) {
            return dPlayer.valueOf(this.inventory.getIdHolder());
        }
        org.bukkit.inventory.InventoryHolder holder = this.inventory.getInventory().getHolder();
        if (holder != null) {
            if (holder instanceof dNPC) {
                return (dNPC)holder;
            }
            if (holder instanceof Player) {
                return new dPlayer((Player)holder);
            }
            if (holder instanceof Entity) {
                return new dEntity((Entity)holder);
            }
            if (holder instanceof DoubleChest) {
                return new dLocation(((DoubleChest)holder).getLocation());
            }
            if (holder instanceof BlockState) {
                return new dLocation(((BlockState)holder).getLocation());
            }
        } else {
            return new Element(this.inventory.getIdHolder());
        }
        return null;
    }

    public void setHolder(dPlayer player) {
        if (this.inventory.getIdType().equals("enderchest")) {
            this.inventory.setInventory(player.getBukkitEnderChest(), player);
        } else if (this.inventory.getIdType().equals("workbench")) {
            this.inventory.setInventory((Inventory)player.getBukkitWorkbench(), player);
        } else {
            this.inventory.setInventory((Inventory)player.getBukkitInventory(), player);
        }
    }

    public void setHolder(dNPC npc) {
        this.inventory.setInventory(npc.getInventory());
    }

    public void setHolder(dEntity entity) {
        this.inventory.setInventory(entity.getBukkitInventory());
    }

    public void setHolder(dLocation location) {
        this.inventory.setInventory(location.getBukkitInventory());
    }

    public void setHolder(Element element) {
        if (element.matchesEnum((Enum[])InventoryType.values())) {
            this.inventory.setInventory(Bukkit.getServer().createInventory(null, InventoryType.valueOf((String)element.asString().toUpperCase())));
        }
    }

    @Override
    public String getPropertyString() {
        if (this.holder == null || this.inventory.getIdType().equals("generic") && this.inventory.getIdHolder().equals("CHEST")) {
            return null;
        }
        return this.holder.identify();
    }

    @Override
    public String getPropertyId() {
        return "holder";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("id_holder")) {
            if (this.holder == null) {
                return null;
            }
            return this.holder.getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("holder")) {
            Element value = mechanism.getValue();
            if (value.matchesEnum((Enum[])InventoryType.values())) {
                this.setHolder(value);
            } else if (value.matchesType(dPlayer.class)) {
                this.setHolder(value.asType(dPlayer.class));
            } else if (Depends.citizens != null && value.matchesType(dNPC.class)) {
                this.setHolder(value.asType(dNPC.class));
            } else if (value.matchesType(dEntity.class)) {
                this.setHolder(value.asType(dEntity.class));
            } else if (value.matchesType(dLocation.class)) {
                this.setHolder(value.asType(dLocation.class));
            }
        }
    }
}

