/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemAttributeNBT
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getMaterial().getMaterial() != Material.AIR;
    }

    public static ItemAttributeNBT getFrom(dObject item) {
        if (!ItemAttributeNBT.describes(item)) {
            return null;
        }
        return new ItemAttributeNBT((dItem)item);
    }

    private ItemAttributeNBT(dItem item) {
        this.item = item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        String prop;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("nbt_attributes") && (prop = this.getPropertyString()) != null) {
            return new Element(prop).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ItemStack itemStack = this.item.getItemStack();
        List<CustomNBT.AttributeReturn> nbtKeys = CustomNBT.getAttributes(itemStack);
        if (nbtKeys != null && !nbtKeys.isEmpty()) {
            dList list = new dList();
            for (CustomNBT.AttributeReturn atr : nbtKeys) {
                list.add(EscapeTags.Escape(atr.attr) + "/" + EscapeTags.Escape(atr.slot) + "/" + atr.op + "/" + atr.amt);
            }
            return list.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "nbt_attributes";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("nbt_attributes")) {
            dList list = mechanism.getValue().asType(dList.class);
            ItemStack itemStack = this.item.getItemStack();
            for (String string : list) {
                String[] split = string.split("/");
                String attribute = EscapeTags.unEscape(split[0]);
                String slot = EscapeTags.unEscape(split[1]);
                int op = new Element(split[2]).asInt();
                double amt = new Element(split[3]).asDouble();
                itemStack = CustomNBT.addAttribute(itemStack, attribute, slot, op, amt);
            }
            this.item.setItemStack(itemStack);
        }
    }
}

