/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.List;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.scripts.requirements.RequirementsMode;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.ChatColor;

public class RequirementChecker {
    public boolean check(RequirementsContext context) {
        if (context.mode.getMode() == RequirementsMode.Mode.NONE || context.list.isEmpty()) {
            return true;
        }
        dB.echoDebug((Debuggable)context.getScriptContainer(), ChatColor.YELLOW + "CHECK! Now checking '" + context.container.getName() + "'");
        dB.echoDebug((Debuggable)context.getScriptContainer(), "Requirement mode: '" + context.mode.getMode().toString() + "'");
        boolean firstReqMet = false;
        boolean firstReqChecked = false;
        int numberMet = 0;
        for (String reqEntry : context.list) {
            List<String> argumentList;
            String reqString;
            boolean negativeRequirement = false;
            if (reqEntry.startsWith("-")) {
                negativeRequirement = true;
                reqEntry = reqEntry.substring(1);
            }
            if ((reqString = (argumentList = TagManager.fillArguments(aH.buildArgs(reqEntry), (TagContext)new BukkitTagContext(context.player, context.npc, false, null, dB.shouldDebug(context.getScriptContainer()), new dScript(context.getScriptContainer())))).get(0).toUpperCase()).equalsIgnoreCase("valueof")) {
                String arg = argumentList.get(1);
                if (arg.equalsIgnoreCase("true")) {
                    if (!negativeRequirement) {
                        dB.echoApproval("Checking 'VALUEOF " + arg + "... requirement met!");
                        ++numberMet;
                        continue;
                    }
                    dB.echoApproval("Checking '-VALUEOF " + arg + "...requirement not met!");
                    continue;
                }
                if (!negativeRequirement) {
                    dB.echoApproval("Checking 'VALUEOF " + arg + "...requirement not met!");
                    continue;
                }
                dB.echoApproval("Checking '-VALUEOF " + arg + "...requirement met!");
                ++numberMet;
                continue;
            }
            if (DenizenAPI.getCurrentInstance().getRequirementRegistry().list().containsKey(reqString)) {
                AbstractRequirement requirement = DenizenAPI.getCurrentInstance().getRequirementRegistry().get(reqString);
                argumentList.remove(0);
                try {
                    int numArguments = argumentList.isEmpty() ? 0 : argumentList.size();
                    int neededArguments = requirement.requirementOptions.REQUIRED_ARGS;
                    if (numArguments == 0 && neededArguments > 0 || numArguments < neededArguments) {
                        throw new RequirementCheckException("Not enough arguments (" + numArguments + " / " + neededArguments + ")");
                    }
                    if (requirement.check(context, argumentList) != negativeRequirement) {
                        if (!firstReqChecked) {
                            firstReqMet = true;
                            firstReqChecked = true;
                        }
                        ++numberMet;
                        dB.echoApproval("Checked '" + requirement.getName() + "' ...requirement met!");
                        continue;
                    }
                    if (!firstReqChecked) {
                        firstReqMet = false;
                        firstReqChecked = true;
                    }
                    dB.echoApproval("Checked '" + requirement.getName() + "' ...requirement not met!");
                }
                catch (Throwable e) {
                    if (e instanceof RequirementCheckException) {
                        String msg = e.getMessage().isEmpty() || e == null ? "No Error message defined!" : e.getMessage();
                        dB.echoError("Woah! Invalid arguments were specified: " + msg);
                        dB.echoError("Usage: " + requirement.getUsageHint());
                        continue;
                    }
                    dB.echoError("Woah! An exception has been called " + (requirement != null ? "for Requirement '" + requirement.getName() + "'" : "") + "!");
                    dB.echoError(e);
                }
                continue;
            }
            dB.echoError("Requirement '" + reqEntry.split(" ")[0] + "' not found! Check that the requirement is installed!");
        }
        if (context.mode.getMode() == RequirementsMode.Mode.ALL && numberMet == context.list.size()) {
            return true;
        }
        if (context.mode.getMode() == RequirementsMode.Mode.ANY_NUM) {
            return numberMet >= context.mode.modeInt;
        }
        if (context.mode.getMode() == RequirementsMode.Mode.FIRST_AND_ANY_NUM) {
            return firstReqMet && numberMet <= context.mode.modeInt;
        }
        return false;
    }
}

