/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.debugging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.AbstractLoggerWrapper;

public class LogInterceptor
extends PrintStream {
    boolean redirected = false;
    public PrintStream standardOut;

    public LogInterceptor() {
        super(new LoggerOutputStream((Logger)new LoggerOutputIntercept((AbstractLogger)LogManager.getRootLogger()), Level.INFO), true);
    }

    public void redirectOutput() {
        if (this.redirected) {
            return;
        }
        this.standardOut = System.out;
        System.setOut(this);
    }

    public void standardOutput() {
        if (!this.redirected) {
            return;
        }
        System.setOut(this.standardOut);
    }

    private static class LoggerOutputStream
    extends ByteArrayOutputStream {
        private final String separator = System.getProperty("line.separator");
        private final Logger logger;
        private final Level level;

        public LoggerOutputStream(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            LoggerOutputStream loggerOutputStream = this;
            synchronized (loggerOutputStream) {
                super.flush();
                String record = this.toString();
                super.reset();
                if (record.length() > 0 && !record.equals(this.separator)) {
                    this.logger.log(this.level, record);
                }
            }
        }
    }

    private static class LoggerOutputIntercept
    extends AbstractLoggerWrapper {
        private final Logger logger;

        private LoggerOutputIntercept(AbstractLogger logger) {
            super(logger, logger.getName(), logger.getMessageFactory());
            this.logger = logger;
        }

        public void log(Marker marker, String fqcn, Level level, Message data, Throwable t) {
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("message", new Element(Denizen.cleanseLog(data.getFormattedMessage())));
            context.put("level", new Element(level.name()));
            List<String> Determinations = OldEventManager.doEvents(Arrays.asList("console output"), new BukkitScriptEntryData(null, null), context);
            for (String str : Determinations) {
                if (!str.equalsIgnoreCase("cancelled")) continue;
                return;
            }
            super.log(marker, fqcn, level, data, t);
        }
    }
}

