/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.enums.CustomEntityType;
import net.aufdemrand.denizen.nms.interfaces.CustomEntity;
import net.aufdemrand.denizen.nms.interfaces.CustomEntityHelper;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Gravity;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class DenizenEntityType {
    private static final Map<String, DenizenEntityType> registeredTypes = new HashMap<String, DenizenEntityType>();
    private final EntityType bukkitEntityType;
    private final String name;
    private final String lowercaseName;
    private final double gravity;
    private final CustomEntityType customEntityType;

    private DenizenEntityType(EntityType entityType) {
        this.bukkitEntityType = entityType;
        this.name = entityType.name();
        this.lowercaseName = CoreUtilities.toLowerCase(this.name);
        this.gravity = Gravity.getGravity(entityType);
        this.customEntityType = null;
    }

    private DenizenEntityType(String name, Class<? extends CustomEntity> entityType) {
        this(name, entityType, 0.115);
    }

    private DenizenEntityType(String name, Class<? extends CustomEntity> entityType, double gravity) {
        EntityType bukkitEntityType = EntityType.UNKNOWN;
        if (entityType != null) {
            for (EntityType type : EntityType.values()) {
                Class clazz = type.getEntityClass();
                if (clazz == null || !clazz.isAssignableFrom(entityType)) continue;
                bukkitEntityType = type;
                break;
            }
        }
        this.bukkitEntityType = bukkitEntityType;
        this.name = name.toUpperCase();
        this.lowercaseName = CoreUtilities.toLowerCase(name);
        this.gravity = gravity;
        this.customEntityType = CustomEntityType.valueOf(name.toUpperCase());
    }

    public Entity spawnNewEntity(Location location, ArrayList<Mechanism> mechanisms) {
        try {
            if (this.name.equals("DROPPED_ITEM")) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(dItem.class)) continue;
                    itemStack = mechanism.getValue().asType(dItem.class).getItemStack();
                    break;
                }
                return location.getWorld().dropItem(location, itemStack);
            }
            if (!this.isCustom()) {
                return location.getWorld().spawnEntity(location, this.bukkitEntityType);
            }
            CustomEntityHelper customEntityHelper = NMSHandler.getInstance().getCustomEntityHelper();
            switch (this.customEntityType) {
                case FAKE_ARROW: {
                    return customEntityHelper.spawnFakeArrow(location);
                }
                case FAKE_PLAYER: {
                    if (!Settings.packetInterception()) break;
                    String name = null;
                    String skin = null;
                    for (Mechanism mechanism : mechanisms) {
                        if (mechanism.matches("name")) {
                            name = mechanism.getValue().asString();
                        } else if (mechanism.matches("skin")) {
                            skin = mechanism.getValue().asString();
                        }
                        if (name == null || skin == null) continue;
                        break;
                    }
                    return customEntityHelper.spawnFakePlayer(location, name, skin);
                }
                case ITEM_PROJECTILE: {
                    ItemStack itemStack = new ItemStack(Material.STONE);
                    for (Mechanism mechanism : mechanisms) {
                        if (!mechanism.matches("item") || !mechanism.requireObject(dItem.class)) continue;
                        itemStack = mechanism.getValue().asType(dItem.class).getItemStack();
                    }
                    return customEntityHelper.spawnItemProjectile(location, itemStack);
                }
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public double getGravity() {
        return this.gravity;
    }

    public EntityType getBukkitEntityType() {
        return this.bukkitEntityType;
    }

    public static void registerEntityType(String name, Class<? extends CustomEntity> entityType) {
        registeredTypes.put(name.toUpperCase(), new DenizenEntityType(name, entityType));
    }

    public static boolean isRegistered(String name) {
        return registeredTypes.containsKey(name.toUpperCase());
    }

    public static DenizenEntityType getByName(String name) {
        return registeredTypes.get(name.toUpperCase());
    }

    public static DenizenEntityType getByEntity(Entity entity) {
        if (entity instanceof CustomEntity) {
            return DenizenEntityType.getByName(((CustomEntity)entity).getEntityTypeName());
        }
        return DenizenEntityType.getByName(entity.getType().name());
    }

    public boolean isCustom() {
        return this.customEntityType != null;
    }

    static {
        for (EntityType entityType : EntityType.values()) {
            registeredTypes.put(entityType.name(), new DenizenEntityType(entityType));
        }
    }
}

