/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ScriptEntry
implements Cloneable,
Debuggable {
    private String command;
    private AbstractCommand actualCommand;
    private List<String> args;
    private List<String> pre_tagged_args;
    private List<String> modified_arguments;
    private boolean instant = false;
    private boolean waitfor = false;
    public ScriptEntryData entryData;
    private dScript script = null;
    private ScriptQueue queue = null;
    private List<BracedCommand.BracedData> bracedSet = null;
    private Map<String, Object> objects = new HashMap<String, Object>();
    private List<Object> insideList;
    public boolean has_tags = false;
    private ScriptEntry owner = null;
    private Object data;
    public List<String> tracked_objects = new ArrayList<String>();
    public boolean fallbackDebug = true;

    public List<BracedCommand.BracedData> getBracedSet() {
        return this.bracedSet;
    }

    public void setBracedSet(List<BracedCommand.BracedData> set) {
        this.bracedSet = set;
    }

    public ScriptEntry clone() throws CloneNotSupportedException {
        ScriptEntry se = (ScriptEntry)super.clone();
        se.objects = new HashMap<String, Object>();
        se.modified_arguments = new ArrayList<String>(this.modified_arguments);
        se.entryData = this.entryData.clone();
        return se;
    }

    public List<Object> getInsideList() {
        return this.insideList;
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script) throws ScriptEntryCreationException {
        this(command, arguments, script, null);
    }

    public ScriptEntry(String command, String[] arguments, ScriptContainer script, List<Object> insides) throws ScriptEntryCreationException {
        if (command == null) {
            throw new ScriptEntryCreationException("dCommand 'name' cannot be null!");
        }
        this.entryData = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.command = command.toUpperCase();
        this.insideList = insides;
        if (script != null) {
            this.script = script.getAsScriptArg();
        }
        if (command.length() > 0) {
            if (command.charAt(0) == '^') {
                this.instant = true;
                this.command = command.substring(1).toUpperCase();
            } else if (command.charAt(0) == '~') {
                this.command = command.substring(1).toUpperCase();
                if (DenizenCore.getCommandRegistry().get(this.command) instanceof Holdable) {
                    this.waitfor = true;
                } else {
                    dB.echoError("The command '" + this.command + "' cannot be waited for!");
                }
            }
            this.actualCommand = DenizenCore.getCommandRegistry().get(this.command);
        } else {
            this.actualCommand = null;
        }
        if (arguments != null) {
            this.args = Arrays.asList(arguments);
            this.pre_tagged_args = Arrays.asList(arguments);
            this.modified_arguments = Arrays.asList(arguments);
        } else {
            this.args = new ArrayList<String>();
            this.pre_tagged_args = new ArrayList<String>();
            this.modified_arguments = new ArrayList<String>();
        }
        block0: for (String arg : this.args) {
            boolean left = false;
            boolean right = false;
            for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (c == '<') {
                    left = true;
                }
                if (c == '>') {
                    right = true;
                }
                if (!left || !right) continue;
                this.has_tags = true;
                break block0;
            }
        }
        if (this.actualCommand != null && this.actualCommand instanceof BracedCommand) {
            BracedCommand.getBracedCommands(this);
        }
    }

    public ScriptEntry addObject(String key, Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof dObject) {
            ((dObject)object).setPrefix(key);
        }
        this.objects.put(CoreUtilities.toLowerCase(key), object);
        return this;
    }

    public ScriptEntry defaultObject(String key, Object ... objects) throws InvalidArgumentsException {
        if (!this.objects.containsKey(CoreUtilities.toLowerCase(key))) {
            for (Object obj : objects) {
                if (obj == null) continue;
                this.addObject(key, obj);
                break;
            }
        }
        if (!this.hasObject(key)) {
            throw new InvalidArgumentsException("Missing '" + key + "' argument!");
        }
        return this;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public List<String> getOriginalArguments() {
        return this.pre_tagged_args;
    }

    public List<String> modifiedArguments() {
        return this.modified_arguments;
    }

    public String getCommandName() {
        return this.command;
    }

    public AbstractCommand getCommand() {
        return this.actualCommand;
    }

    public ScriptEntry setArguments(List<String> arguments) {
        this.args = arguments;
        return this;
    }

    public void setCommandName(String commandName) {
        this.command = commandName;
    }

    public void setOwner(ScriptEntry owner) {
        this.owner = owner;
    }

    public ScriptEntry getOwner() {
        return this.owner;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object result) {
        this.data = result;
    }

    public void copyFrom(ScriptEntry entry) {
        this.entryData = entry.entryData.clone();
        this.setSendingQueue(entry.getResidingQueue());
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(CoreUtilities.toLowerCase(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T extends dObject> T getdObject(String key) {
        try {
            Object gotten = this.objects.get(CoreUtilities.toLowerCase(key));
            if (gotten instanceof Enum) {
                return (T)new Element(((Enum)gotten).name());
            }
            return (T)((dObject)gotten);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Element getElement(String key) {
        try {
            return (Element)this.objects.get(CoreUtilities.toLowerCase(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(CoreUtilities.toLowerCase(key));
    }

    public dScript getScript() {
        return this.script;
    }

    public ScriptEntry setScript(String scriptName) {
        this.script = dScript.valueOf(scriptName);
        return this;
    }

    public ScriptQueue getResidingQueue() {
        return this.queue;
    }

    public void setSendingQueue(ScriptQueue scriptQueue) {
        this.queue = scriptQueue;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.instant = instant;
        return this;
    }

    public boolean shouldWaitFor() {
        return this.waitfor;
    }

    public ScriptEntry setFinished(boolean finished) {
        this.waitfor = !finished;
        return this;
    }

    public ScriptEntry trackObject(String key) {
        this.tracked_objects.add(CoreUtilities.toLowerCase(key));
        return this;
    }

    @Override
    public boolean shouldDebug() {
        if (this.script == null || this.script.getContainer() == null) {
            return this.fallbackDebug;
        }
        return this.script.getContainer().shouldDebug();
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.script.getName().equalsIgnoreCase(criteria.replace("s@", ""));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.getOriginalArguments()) {
            sb.append(" \"" + str + "\"");
        }
        return this.command + sb.toString();
    }
}

