/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class EntityExplodesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityExplodesScriptEvent instance;
    public dEntity entity;
    public dList blocks;
    public dLocation location;
    public Float strength;
    private Boolean blockSet;
    public EntityExplodeEvent event;

    public EntityExplodesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("explodes");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String target = CoreUtilities.getXthArg(0, lower);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityExplodes";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityExplodeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.strength = Float.valueOf(aH.getFloatFrom(determination));
            return true;
        }
        if (dList.matches(determination)) {
            this.blocks = new dList();
            this.blockSet = true;
            for (String loc : dList.valueOf(determination)) {
                dLocation location = dLocation.valueOf(loc);
                if (location == null) {
                    dB.echoError("Invalid location '" + loc + "' check [" + this.getName() + "]: '  for " + container.getName());
                    continue;
                }
                this.blocks.add(location.identifySimple());
            }
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        if (name.equals("strength")) {
            return new Element(this.strength.floatValue());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.location = new dLocation(event.getLocation());
        this.strength = Float.valueOf(event.getYield());
        this.blocks = new dList();
        this.blockSet = false;
        for (Block block : event.blockList()) {
            this.blocks.add(new dLocation(block.getLocation()).identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        if (this.blockSet.booleanValue()) {
            event.blockList().clear();
            if (this.blocks.size() > 0) {
                event.blockList().clear();
                for (String loc : this.blocks) {
                    dLocation location = dLocation.valueOf(loc);
                    event.blockList().add(location.getWorld().getBlockAt((Location)location));
                }
            }
        }
        event.setYield(this.strength.floatValue());
    }
}

