/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.plugin.Plugin;

public class LingeringPotionSplashScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LingeringPotionSplashScriptEvent instance;
    public LingeringPotionSplashEvent event;
    public dLocation location;
    public Element duration;
    public dEntity entity;
    public Element radius;
    public dItem item;

    public LingeringPotionSplashScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(2, lower);
        if (!CoreUtilities.getXthArg(0, lower).equals("lingering")) {
            return false;
        }
        return cmd.equals("splash") || cmd.equals("splashes");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String iTest = CoreUtilities.getXthArg(1, s);
        if (!this.tryItem(this.item, iTest)) {
            return false;
        }
        return !this.runInCheck(scriptContainer, s, lower, this.location);
    }

    @Override
    public String getName() {
        return "LingeringPotionSplash";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        LingeringPotionSplashEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("radius")) {
            return this.radius;
        }
        if (name.equals("duration")) {
            return this.duration;
        }
        if (name.equals("potion")) {
            return this.item;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        AreaEffectCloud cloud = event.getAreaEffectCloud();
        this.item = new dItem(event.getEntity().getItem());
        this.duration = new Element(cloud.getDuration());
        this.entity = new dEntity((Entity)event.getEntity());
        this.location = this.entity.getLocation();
        this.radius = new Element(cloud.getRadius());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

