/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.nms.abstracts.BiomeNMS;
import net.aufdemrand.denizen.nms.util.ReflectionHelper;
import net.minecraft.server.v1_8_R3.BiomeBase;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Chunk;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityTypes;
import net.minecraft.server.v1_8_R3.EnumCreatureType;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.block.CraftBlock;
import org.bukkit.entity.EntityType;

public class BiomeNMS_v1_8_R3
extends BiomeNMS {
    private final BiomeBase biomeBase;
    private static final Map<Class<? extends Entity>, Integer> ENTITY_CLASS_ID_MAP = (Map)ReflectionHelper.getFieldValue(EntityTypes.class, "f", null);

    public BiomeNMS_v1_8_R3(Biome biome) {
        super(biome);
        this.biomeBase = CraftBlock.biomeToBiomeBase((Biome)biome);
    }

    @Override
    public float getHumidity() {
        return this.biomeBase.humidity;
    }

    @Override
    public float getTemperature() {
        return this.biomeBase.temperature;
    }

    @Override
    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.AMBIENT);
    }

    @Override
    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.CREATURE);
    }

    @Override
    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.MONSTER);
    }

    @Override
    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.WATER_CREATURE);
    }

    @Override
    public void setHumidity(float humidity) {
        this.biomeBase.humidity = humidity;
    }

    @Override
    public void setTemperature(float temperature) {
        this.biomeBase.temperature = temperature;
    }

    @Override
    public void changeBlockBiome(Location location) {
        Chunk chunk;
        int x = location.getBlockX();
        int z = location.getBlockZ();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        if (world.isLoaded(new BlockPosition(x, 0, z)) && (chunk = world.getChunkAtWorldCoords(new BlockPosition(x, 0, z))) != null) {
            byte[] biomevals = chunk.getBiomeIndex();
            biomevals[(z & 0xF) << 4 | x & 0xF] = (byte)this.biomeBase.id;
        }
    }

    @Override
    protected boolean getDoesRain() {
        Boolean rains = (Boolean)ReflectionHelper.getFieldValue(BiomeBase.class, "ay", this.biomeBase);
        if (rains != null) {
            return rains;
        }
        return false;
    }

    @Override
    protected boolean getDoesSnow() {
        Boolean snows = (Boolean)ReflectionHelper.getFieldValue(BiomeBase.class, "ax", this.biomeBase);
        if (snows != null) {
            return snows;
        }
        return false;
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (BiomeBase.BiomeMeta meta : this.biomeBase.getMobs(creatureType)) {
            entityTypes.add(EntityType.fromId((int)ENTITY_CLASS_ID_MAP.get(meta.b)));
        }
        return entityTypes;
    }
}

