/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InvisibleTrait
extends Trait
implements Listener,
Toggleable {
    @Persist(value="")
    private boolean invisible = true;
    PotionEffect invis = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1);

    public InvisibleTrait() {
        super("invisible");
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        if (invisible) {
            this.setInvisible();
        } else if (this.npc.isSpawned() && this.npc.getEntity() instanceof LivingEntity) {
            if (((LivingEntity)this.npc.getEntity()).hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                ((LivingEntity)this.npc.getEntity()).removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            if (this.npc.getEntity().getType() == EntityType.ARMOR_STAND) {
                ((ArmorStand)this.npc.getEntity()).setVisible(true);
            }
        }
    }

    private void setInvisible() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof LivingEntity) {
            if (this.npc.getEntity().getType() == EntityType.PLAYER) {
                this.npc.data().setPersistent("removefromplayerlist", (Object)false);
                NMS.addOrRemoveFromPlayerList((Entity)this.npc.getEntity(), (boolean)false);
            } else if (this.npc.getEntity().getType() == EntityType.ARMOR_STAND) {
                ((ArmorStand)this.npc.getEntity()).setVisible(false);
            }
            this.invis.apply((LivingEntity)this.npc.getEntity());
        }
    }

    public void onSpawn() {
        if (this.invisible) {
            this.setInvisible();
        }
    }

    public boolean toggle() {
        this.setInvisible(!this.invisible);
        return this.invisible;
    }

    public void onRemove() {
        this.setInvisible(false);
    }

    public void onAttach() {
        this.setInvisible(this.invisible);
    }
}

