/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;

public class EntitySkeleton
implements Property {
    dEntity skeleton;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntity() instanceof Skeleton;
    }

    public static EntitySkeleton getFrom(dObject entity) {
        if (!EntitySkeleton.describes(entity)) {
            return null;
        }
        return new EntitySkeleton((dEntity)entity);
    }

    private EntitySkeleton(dEntity entity) {
        this.skeleton = entity;
    }

    @Override
    public String getPropertyString() {
        return ((Skeleton)this.skeleton.getBukkitEntity()).getSkeletonType().name();
    }

    @Override
    public String getPropertyId() {
        return "skeleton";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("skeleton_type")) {
            return new Element(((Skeleton)this.skeleton.getBukkitEntity()).getSkeletonType().name()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skeleton") && mechanism.requireEnum(false, (Enum<?>[])Skeleton.SkeletonType.values())) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
                Skeleton.SkeletonType skeletonType = Skeleton.SkeletonType.valueOf((String)mechanism.getValue().asString().toUpperCase());
                Skeleton current = (Skeleton)this.skeleton.getBukkitEntity();
                Skeleton newSkeleton = null;
                switch (skeletonType) {
                    case NORMAL: {
                        newSkeleton = (Skeleton)current.getLocation().getWorld().spawnEntity(current.getLocation(), EntityType.SKELETON);
                        break;
                    }
                    case WITHER: {
                        newSkeleton = (Skeleton)current.getLocation().getWorld().spawnEntity(current.getLocation(), EntityType.WITHER_SKELETON);
                        break;
                    }
                    case STRAY: {
                        newSkeleton = (Skeleton)current.getLocation().getWorld().spawnEntity(current.getLocation(), EntityType.STRAY);
                    }
                }
                newSkeleton.setHealth(current.getHealth());
                newSkeleton.getEquipment().setArmorContents(current.getEquipment().getArmorContents());
                current.remove();
                this.skeleton.setEntity((Entity)newSkeleton);
            } else {
                ((Skeleton)this.skeleton.getBukkitEntity()).setSkeletonType(Skeleton.SkeletonType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            }
        }
    }
}

