/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.bukkit.ScriptFailEvent;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class FailCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (arg.matchesArgumentType(dPlayer.class)) {
                scriptEntry.addObject("player", arg.asType(dPlayer.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("player", ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer());
        scriptEntry.defaultObject("script", scriptEntry.getScript());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getObject("script");
        dPlayer player = (dPlayer)scriptEntry.getObject("player");
        dB.report(scriptEntry, this.getName(), player.debug() + script.debug());
        dB.echoError(scriptEntry.getResidingQueue(), "The Fail command is outdated, use flags intead!");
        FailCommand.failScript(player.getName(), script.getName());
    }

    public static void resetFails(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        DenizenAPI._saves().set("Players." + playerName + "." + scriptName + ".Failed", null);
    }

    public static void failScript(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        int fails = DenizenAPI._saves().getInt("Players." + playerName + "." + scriptName + ".Failed", 0);
        DenizenAPI._saves().set("Players." + playerName + "." + scriptName + ".Failed", (Object)(++fails));
        ScriptFailEvent event = new ScriptFailEvent(playerName, scriptName, fails);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public static int getScriptFails(String playerName, String scriptName) {
        return DenizenAPI.getCurrentInstance().getSaves().getInt("Players." + playerName + "." + scriptName.toUpperCase() + ".Failed", 0);
    }
}

