/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Iterator;
import java.util.List;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class RepeatCommand
extends BracedCommand {
    @Override
    public void onEnable() {
        this.setBraced();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Iterator<aH.Argument> iterator = aH.interpret(scriptEntry.getArguments()).iterator();
        if (iterator.hasNext()) {
            aH.Argument arg = iterator.next();
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("qty", arg.asElement());
            } else if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", Element.TRUE);
            } else if (!scriptEntry.hasObject("next") && arg.matches("next")) {
                scriptEntry.addObject("next", Element.TRUE);
            } else if (!scriptEntry.hasObject("callback") && arg.matches("\u0000CALLBACK")) {
                scriptEntry.addObject("callback", Element.TRUE);
            } else {
                arg.reportUnhandled();
            }
        }
        if (!(scriptEntry.hasObject("qty") || scriptEntry.hasObject("stop") || scriptEntry.hasObject("next") || scriptEntry.hasObject("callback"))) {
            throw new InvalidArgumentsException("Must specify a quantity or 'stop' or 'next'!");
        }
        scriptEntry.addObject("braces", RepeatCommand.getBracedCommands(scriptEntry));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element stop = scriptEntry.getElement("stop");
        Element next = scriptEntry.getElement("next");
        Element callback = scriptEntry.getElement("callback");
        Element quantity = scriptEntry.getElement("qty");
        if (stop != null && stop.asBoolean()) {
            dB.report(scriptEntry, this.getName(), stop.debug());
            boolean hasnext = false;
            for (int i = 0; i < scriptEntry.getResidingQueue().getQueueSize(); ++i) {
                ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equalsIgnoreCase("repeat") || args.size() <= 0 || !args.get(0).equalsIgnoreCase("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (scriptEntry.getResidingQueue().getQueueSize() > 0) {
                    ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (entry.getCommandName().equalsIgnoreCase("repeat") && args.size() > 0 && args.get(0).equalsIgnoreCase("\u0000CALLBACK")) {
                        scriptEntry.getResidingQueue().removeEntry(0);
                        break;
                    }
                    scriptEntry.getResidingQueue().removeEntry(0);
                }
            } else {
                dB.echoError("Cannot stop repeat: not in one!");
            }
            return;
        }
        if (next != null && next.asBoolean()) {
            dB.report(scriptEntry, this.getName(), next.debug());
            boolean hasnext = false;
            for (int i = 0; i < scriptEntry.getResidingQueue().getQueueSize(); ++i) {
                ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equalsIgnoreCase("repeat") || args.size() <= 0 || !args.get(0).equalsIgnoreCase("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (scriptEntry.getResidingQueue().getQueueSize() > 0) {
                    ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (!entry.getCommandName().equalsIgnoreCase("repeat") || args.size() <= 0 || !args.get(0).equalsIgnoreCase("\u0000CALLBACK")) {
                        scriptEntry.getResidingQueue().removeEntry(0);
                        continue;
                    }
                    break;
                }
            } else {
                dB.echoError("Cannot stop repeat: not in one!");
            }
            return;
        }
        if (callback != null && callback.asBoolean()) {
            if (scriptEntry.getOwner() != null && (scriptEntry.getOwner().getCommandName().equalsIgnoreCase("repeat") || scriptEntry.getOwner().getBracedSet() == null || scriptEntry.getOwner().getBracedSet().size() == 0 || scriptEntry.getBracedSet().get((int)0).value.get(scriptEntry.getBracedSet().get((int)0).value.size() - 1) != scriptEntry)) {
                RepeatData data = (RepeatData)scriptEntry.getOwner().getData();
                ++data.index;
                if (data.index <= data.target) {
                    dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Repeat loop " + data.index);
                    scriptEntry.getResidingQueue().addDefinition("value", String.valueOf(data.index));
                    List<ScriptEntry> bracedCommands = BracedCommand.getBracedCommands((ScriptEntry)scriptEntry.getOwner()).get((int)0).value;
                    ScriptEntry callbackEntry = null;
                    try {
                        callbackEntry = new ScriptEntry("REPEAT", new String[]{"\u0000CALLBACK"}, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
                        callbackEntry.copyFrom(scriptEntry);
                    }
                    catch (ScriptEntryCreationException e) {
                        dB.echoError(e);
                    }
                    callbackEntry.setOwner(scriptEntry.getOwner());
                    bracedCommands.add(callbackEntry);
                    for (int i = 0; i < bracedCommands.size(); ++i) {
                        bracedCommands.get(i).setInstant(true);
                        bracedCommands.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
                    }
                    scriptEntry.getResidingQueue().injectEntries(bracedCommands, 0);
                }
            } else {
                dB.echoError("Repeat CALLBACK invalid: not a real callback!");
            }
        } else {
            List<ScriptEntry> bracedCommandsList = ((BracedCommand.BracedData)((List)scriptEntry.getObject((String)"braces")).get((int)0)).value;
            if (bracedCommandsList == null || bracedCommandsList.isEmpty()) {
                dB.echoError("Empty braces!");
                return;
            }
            dB.report(scriptEntry, this.getName(), quantity.debug());
            int target = quantity.asInt();
            if (target <= 0) {
                dB.echoDebug((Debuggable)scriptEntry, "Zero count, not looping...");
                return;
            }
            RepeatData datum = new RepeatData();
            datum.target = target;
            datum.index = 1;
            scriptEntry.setData(datum);
            ScriptEntry callbackEntry = null;
            try {
                callbackEntry = new ScriptEntry("REPEAT", new String[]{"\u0000CALLBACK"}, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
                callbackEntry.copyFrom(scriptEntry);
            }
            catch (ScriptEntryCreationException e) {
                dB.echoError(e);
            }
            callbackEntry.setOwner(scriptEntry);
            bracedCommandsList.add(callbackEntry);
            scriptEntry.getResidingQueue().addDefinition("value", "1");
            for (int i = 0; i < bracedCommandsList.size(); ++i) {
                bracedCommandsList.get(i).setInstant(true);
                bracedCommandsList.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
            }
            scriptEntry.getResidingQueue().injectEntries(bracedCommandsList, 0);
        }
    }

    private class RepeatData {
        public int index;
        public int target;

        private RepeatData() {
        }
    }
}

