/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PauseCommand
extends AbstractCommand {
    private Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);
    int duration;
    PauseType pauseType;
    dNPC dNPC;
    Player player;

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.duration = -1;
        this.pauseType = null;
        this.dNPC = null;
        this.player = null;
        if (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() != null) {
            this.dNPC = ((BukkitScriptEntryData)scriptEntry.entryData).getNPC();
        }
        if (((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() != null) {
            this.player = ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                this.duration = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesArg("WAYPOINTS", arg) || aH.matchesArg("NAVIGATION", arg) || aH.matchesArg("ACTIVITY", arg) || aH.matchesArg("WAYPOINTS", arg)) {
                this.pauseType = PauseType.valueOf(arg.toUpperCase());
                continue;
            }
            dB.echoError(scriptEntry.getResidingQueue(), "Unknown argument '" + arg + "'");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        this.pause(this.dNPC, this.pauseType, !scriptEntry.getCommandName().equalsIgnoreCase("RESUME"));
        if (this.duration > 0) {
            if (this.durations.containsKey(this.dNPC.getCitizen().getId() + this.pauseType.name())) {
                try {
                    DenizenAPI.getCurrentInstance().getServer().getScheduler().cancelTask(this.durations.get(this.dNPC.getCitizen().getId() + this.pauseType.name()).intValue());
                }
                catch (Exception e) {
                    dB.echoError(scriptEntry.getResidingQueue(), "There was an error pausing that!");
                    dB.echoError(scriptEntry.getResidingQueue(), e);
                }
            }
            dB.echoDebug((Debuggable)scriptEntry, "Running delayed task: Unpause " + this.pauseType.toString());
            final ScriptEntry se = scriptEntry;
            this.durations.put(this.dNPC.getId() + this.pauseType.name(), DenizenAPI.getCurrentInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    dB.echoDebug((Debuggable)se, "Running delayed task: Pausing " + PauseCommand.this.pauseType.toString());
                    PauseCommand.this.pause(PauseCommand.this.dNPC, PauseCommand.this.pauseType, false);
                }
            }, (long)(this.duration * 20)));
        }
    }

    public void pause(dNPC denizen, PauseType pauseType, boolean pause) {
        switch (pauseType) {
            case WAYPOINTS: {
                ((Waypoints)denizen.getCitizen().getTrait(Waypoints.class)).getCurrentProvider().setPaused(pause);
                if (pause) {
                    denizen.getNavigator().cancelNavigation();
                }
                return;
            }
            case ACTIVITY: {
                denizen.getCitizen().getDefaultGoalController().setPaused(pause);
                return;
            }
        }
    }

    static enum PauseType {
        ACTIVITY,
        WAYPOINTS,
        NAVIGATION;

    }
}

