/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Duration
implements dObject {
    public static final Duration ZERO = new Duration(0);
    private double seconds;
    private String prefix = "Duration";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static Duration valueOf(String string) {
        return Duration.valueOf(string, null);
    }

    @Fetchable(value="d")
    public static Duration valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] split = (string = string.replace("d@", "")).split("-", 2);
        if (split.length == 2 && Duration.matches(split[0]) && Duration.matches(split[1])) {
            Duration low = Duration.valueOf(split[0]);
            Duration high = Duration.valueOf(split[1]);
            if (low != null && high != null && low.getSecondsAsInt() < high.getSecondsAsInt()) {
                int seconds = CoreUtilities.getRandom().nextInt(high.getSecondsAsInt() - low.getSecondsAsInt() + 1) + low.getSecondsAsInt();
                return new Duration(seconds);
            }
            return null;
        }
        String mg1 = CoreUtilities.toLowerCase(string);
        String mg2 = Character.isDigit(string.charAt(string.length() - 1)) ? string : string.substring(0, string.length() - 1);
        try {
            if (mg1.endsWith("t")) {
                return new Duration(Double.valueOf(mg2) * 0.05);
            }
            if (mg1.endsWith("d")) {
                return new Duration(Double.valueOf(mg2) * 86400.0);
            }
            if (mg1.endsWith("w")) {
                return new Duration(Double.valueOf(mg2) * 604800.0);
            }
            if (mg1.endsWith("m")) {
                return new Duration(Double.valueOf(mg2) * 60.0);
            }
            if (mg1.endsWith("h")) {
                return new Duration(Double.valueOf(mg2) * 3600.0);
            }
            return new Duration(Double.valueOf(mg2));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        try {
            return Duration.valueOf(string) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Duration(double seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(int seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(long ticks) {
        this.seconds = ticks / 20L;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return (int)(this.seconds * 20.0);
    }

    public long getMillis() {
        Double millis = this.seconds * 1000.0;
        return millis.longValue();
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return this.round(this.seconds);
    }

    private int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "duration";
    }

    @Override
    public String identify() {
        return "d@" + this.seconds + "s";
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        Duration.registerTag("in_years", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds / 3.1536E7).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("years", registeredTags.get("in_years"));
        Duration.registerTag("in_weeks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds / 604800.0).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("weeks", registeredTags.get("in_weeks"));
        Duration.registerTag("in_days", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds / 86400.0).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("days", registeredTags.get("in_days"));
        Duration.registerTag("in_hours", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds / 3600.0).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("hours", registeredTags.get("in_hours"));
        Duration.registerTag("in_minutes", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds / 60.0).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("minutes", registeredTags.get("in_minutes"));
        Duration.registerTag("in_seconds", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("seconds", registeredTags.get("in_seconds"));
        Duration.registerTag("in_milliseconds", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).seconds * 1000.0).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("milliseconds", registeredTags.get("in_milliseconds"));
        Duration.registerTag("in_ticks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element((long)(((Duration)object).seconds * 20.0)).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("ticks", registeredTags.get("in_ticks"));
        Duration.registerTag("sub", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag d@duration.sub[...] must have a value.");
                    return null;
                }
                return new Duration(((Duration)object).getTicks() - Duration.valueOf(attribute.getContext(1)).getTicks()).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("add", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag d@duration.add[...] must have a value.");
                    return null;
                }
                return new Duration(((Duration)object).getTicks() + Duration.valueOf(attribute.getContext(1)).getTicks()).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("time", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                Date currentDate = new Date(((Duration)object).getTicks() * 50L);
                SimpleDateFormat format = new SimpleDateFormat();
                if ((attribute = attribute.fulfill(1)).startsWith("year")) {
                    return new Element(currentDate.getYear() + 1900).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("month")) {
                    return new Element(currentDate.getMonth() + 1).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("day")) {
                    return new Element(currentDate.getDate()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("day_of_week")) {
                    return new Element(currentDate.getDay()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("hour")) {
                    return new Element(currentDate.getHours()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("minute")) {
                    return new Element(currentDate.getMinutes()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("second")) {
                    return new Element(currentDate.getSeconds()).getAttribute(attribute.fulfill(1));
                }
                format.applyPattern("EEE, d MMM yyyy HH:mm:ss");
                return new Element(format.format(currentDate)).getAttribute(attribute);
            }
        });
        Duration.registerTag("prefix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).prefix).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("debug", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.debug()).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Duration").getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("formatted", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((Duration)object).formatted()).getAttribute(attribute.fulfill(1));
            }
        });
        Duration.registerTag("value", registeredTags.get("formatted"));
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public String formatted() {
        long seconds = (long)this.seconds;
        long days = seconds / 86400L;
        long hours = (seconds - days * 86400L) / 3600L;
        long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
        seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
        String timeString = "";
        if (days > 0L) {
            timeString = String.valueOf(days) + "d ";
        }
        if (hours > 0L) {
            timeString = timeString + String.valueOf(hours) + "h ";
        }
        if (minutes > 0L && days == 0L) {
            timeString = timeString + String.valueOf(minutes) + "m ";
        }
        if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
            timeString = timeString + String.valueOf(seconds) + "s";
        }
        if (timeString.isEmpty()) {
            timeString = this.seconds <= 0.0 ? "forever" : (double)((long)(this.seconds * 100.0)) / 100.0 + "s";
        }
        return timeString.trim();
    }
}

