/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags;

import java.util.List;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class ReplaceableTagEvent {
    private final TagContext context;
    private boolean instant = false;
    private boolean wasReplaced = false;
    private String alternative = null;
    private boolean alternative_tagged = false;
    private String replaced = null;
    private String value = null;
    private boolean value_tagged = false;
    private Attribute core_attributes = null;
    private ScriptEntry scriptEntry = null;
    public String raw_tag;
    private dScript script;

    public ReplaceableTagEvent(String tag, TagContext context) {
        int valueLoc;
        int alternativeLoc;
        char start;
        this.scriptEntry = context.entry;
        this.script = context.script;
        this.context = context;
        this.replaced = tag;
        if (tag.length() > 0 && ((start = tag.charAt(0)) == '!' || start == '^')) {
            this.instant = true;
            tag = tag.substring(1);
        }
        if ((alternativeLoc = this.locateAlternative(tag)) >= 0) {
            this.alternative = tag.substring(alternativeLoc + 2).trim();
            tag = tag.substring(0, alternativeLoc);
        }
        if ((valueLoc = this.locateValue(tag)) > 0) {
            this.value = tag.substring(valueLoc + 1);
            tag = tag.substring(0, valueLoc);
        }
        this.raw_tag = tag.trim();
        this.core_attributes = new Attribute(this.raw_tag, this.scriptEntry, context);
        this.core_attributes.setHadAlternative(this.hasAlternative());
    }

    private int locateValue(String tag) {
        int bracks = 0;
        int bracks2 = 0;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '<') {
                ++bracks;
                continue;
            }
            if (c == '>') {
                --bracks;
                continue;
            }
            if (bracks == 0 && c == '[') {
                ++bracks2;
                continue;
            }
            if (bracks == 0 && c == ']') {
                --bracks2;
                continue;
            }
            if (c != ':' || bracks != 0 || bracks2 != 0) continue;
            return i;
        }
        return -1;
    }

    private int locateAlternative(String tag) {
        int bracks = 0;
        int bracks2 = 0;
        boolean previousWasTarget = false;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '<') {
                ++bracks;
                continue;
            }
            if (c == '>') {
                --bracks;
                continue;
            }
            if (bracks == 0 && c == '[') {
                ++bracks2;
                continue;
            }
            if (bracks == 0 && c == ']') {
                --bracks2;
                continue;
            }
            if (c == '|' && bracks == 0 && bracks2 == 0) {
                if (previousWasTarget) {
                    return i - 1;
                }
                previousWasTarget = true;
                continue;
            }
            previousWasTarget = false;
        }
        return -1;
    }

    public boolean matches(String tagName) {
        List<String> tagNames = CoreUtilities.split(tagName, ',');
        String name = this.getName();
        for (String string : tagNames) {
            if (!name.equalsIgnoreCase(string.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String ... tagNames) {
        String name = this.getName();
        for (String string : tagNames) {
            if (!name.equalsIgnoreCase(string.trim())) continue;
            return true;
        }
        return false;
    }

    private String StripContext(String input) {
        if (input == null) {
            return null;
        }
        int index = input.indexOf(91);
        if (index < 0 || !input.endsWith("]")) {
            return input;
        }
        return input.substring(0, index);
    }

    public String getName() {
        return this.StripContext(this.core_attributes.getAttribute(1));
    }

    public String getNameContext() {
        return this.core_attributes.getContext(1);
    }

    public boolean hasNameContext() {
        return this.core_attributes.hasContext(1);
    }

    @Deprecated
    public String getType() {
        return this.StripContext(this.core_attributes.getAttribute(2));
    }

    @Deprecated
    public boolean hasType() {
        return this.core_attributes.getAttribute(2).length() > 0;
    }

    @Deprecated
    public String getTypeContext() {
        return this.core_attributes.getContext(2);
    }

    @Deprecated
    public boolean hasTypeContext() {
        return this.core_attributes.hasContext(2);
    }

    @Deprecated
    public String getSubType() {
        return this.StripContext(this.core_attributes.getAttribute(3));
    }

    @Deprecated
    public boolean hasSubType() {
        return this.core_attributes.getAttribute(3).length() > 0;
    }

    @Deprecated
    public String getSubTypeContext() {
        return this.core_attributes.getContext(3);
    }

    @Deprecated
    public boolean hasSubTypeContext() {
        return this.core_attributes.hasContext(3);
    }

    @Deprecated
    public String getSpecifier() {
        return this.StripContext(this.core_attributes.getAttribute(4));
    }

    @Deprecated
    public boolean hasSpecifier() {
        return this.core_attributes.getAttribute(4).length() > 0;
    }

    @Deprecated
    public String getSpecifierContext() {
        return this.core_attributes.getContext(4);
    }

    @Deprecated
    public boolean hasSpecifierContext() {
        return this.core_attributes.hasContext(4);
    }

    public String getValue() {
        if (this.value_tagged) {
            return this.value;
        }
        this.value_tagged = true;
        this.value = TagManager.cleanOutputFully(TagManager.tag(this.value, this.context));
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getAlternative() {
        if (this.alternative_tagged) {
            return this.alternative;
        }
        this.alternative_tagged = true;
        this.alternative = TagManager.cleanOutputFully(TagManager.tag(this.alternative, this.context));
        return this.alternative;
    }

    public boolean hasAlternative() {
        return this.alternative != null;
    }

    public TagContext getContext() {
        return this.context;
    }

    public String getReplaced() {
        return this.replaced;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public dScript getScript() {
        return this.script;
    }

    public boolean replaced() {
        return this.wasReplaced && this.replaced != null;
    }

    public void setReplaced(String string) {
        this.replaced = string;
        this.wasReplaced = string != null;
    }

    public boolean hasScriptEntryAttached() {
        return this.scriptEntry != null;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public Attribute getAttributes() {
        return this.core_attributes;
    }

    public String toString() {
        return this.core_attributes.toString() + (this.hasValue() ? ":" + this.value : "") + (this.hasAlternative() ? "||" + this.alternative : "");
    }
}

