/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;

public class EntityRotation
implements Property {
    dEntity entity;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        return ((dEntity)entity).getBukkitEntityType() == EntityType.PAINTING || ((dEntity)entity).getBukkitEntityType() == EntityType.ITEM_FRAME;
    }

    public static EntityRotation getFrom(dObject entity) {
        if (!EntityRotation.describes(entity)) {
            return null;
        }
        return new EntityRotation((dEntity)entity);
    }

    private EntityRotation(dEntity entity) {
        this.entity = entity;
    }

    private BlockFace getRotation() {
        return ((Hanging)this.entity.getBukkitEntity()).getAttachedFace().getOppositeFace();
    }

    public void setRotation(BlockFace direction) {
        ((Hanging)this.entity.getBukkitEntity()).setFacingDirection(direction, true);
    }

    @Override
    public String getPropertyString() {
        return CoreUtilities.toLowerCase(this.getRotation().name());
    }

    @Override
    public String getPropertyId() {
        return "rotation";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("rotation")) {
            return new Element(CoreUtilities.toLowerCase(this.getRotation().name())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("rotation") && mechanism.requireEnum(false, (Enum<?>[])BlockFace.values())) {
            this.setRotation(BlockFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
    }
}

