/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.npc.NPC;

public class EngageCommand
extends AbstractCommand {
    private static Map<NPC, Long> currentlyEngaged = new HashMap<NPC, Long>();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (!((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("duration", new Duration(0));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Duration duration = (Duration)scriptEntry.getdObject("duration");
        dNPC npc = ((BukkitScriptEntryData)scriptEntry.entryData).getNPC();
        dB.report(scriptEntry, this.getName(), npc.debug() + duration.debug());
        if (duration.getSecondsAsInt() > 0) {
            EngageCommand.setEngaged(npc.getCitizen(), duration.getSecondsAsInt());
        } else {
            EngageCommand.setEngaged(npc.getCitizen(), true);
        }
    }

    public static boolean getEngaged(NPC npc) {
        return currentlyEngaged.containsKey(npc) && currentlyEngaged.get(npc) > System.currentTimeMillis();
    }

    public static void setEngaged(NPC npc, boolean engaged) {
        if (engaged) {
            currentlyEngaged.put(npc, System.currentTimeMillis() + (long)Duration.valueOf(Settings.engageTimeoutInSeconds()).getSeconds() * 1000L);
        }
        if (!engaged) {
            currentlyEngaged.remove(npc);
        }
    }

    public static void setEngaged(NPC npc, int duration) {
        currentlyEngaged.put(npc, System.currentTimeMillis() + (long)(duration * 1000));
    }
}

