/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.nbt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizen.nms.util.jnbt.DoubleTag;
import net.aufdemrand.denizen.nms.util.jnbt.IntTag;
import net.aufdemrand.denizen.nms.util.jnbt.ListTag;
import net.aufdemrand.denizen.nms.util.jnbt.LongTag;
import net.aufdemrand.denizen.nms.util.jnbt.StringTag;
import net.aufdemrand.denizen.nms.util.jnbt.Tag;
import net.aufdemrand.denizen.utilities.nbt.MapOfEnchantments;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class CustomNBT {
    public static final String KEY_DENIZEN = "Denizen NBT";
    public static final String KEY_ATTRIBUTES = "AttributeModifiers";

    public static MapOfEnchantments getEnchantments(ItemStack item) {
        return new MapOfEnchantments(item);
    }

    public static List<AttributeReturn> getAttributes(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        ArrayList<CompoundTag> attribs = new ArrayList<CompoundTag>();
        if (compoundTag.getValue().containsKey(KEY_ATTRIBUTES)) {
            List temp = (List)((Tag)compoundTag.getValue().get(KEY_ATTRIBUTES)).getValue();
            for (Tag tag : temp) {
                attribs.add((CompoundTag)tag);
            }
        }
        ArrayList<AttributeReturn> attrs = new ArrayList<AttributeReturn>();
        for (int i = 0; i < attribs.size(); ++i) {
            CompoundTag ct = (CompoundTag)attribs.get(i);
            AttributeReturn atr = new AttributeReturn();
            atr.attr = (String)((Tag)ct.getValue().get("AttributeName")).getValue();
            atr.slot = ct.getValue().get("Slot") == null ? "mainhand" : (String)((Tag)ct.getValue().get("Slot")).getValue();
            atr.op = (Integer)((Tag)ct.getValue().get("Operation")).getValue();
            Tag t = (Tag)ct.getValue().get("Amount");
            atr.amt = t instanceof IntTag ? (double)((Integer)t.getValue()).intValue() : (t instanceof LongTag ? (double)((Long)t.getValue()).longValue() : (t instanceof DoubleTag ? (Double)t.getValue() : 0.0));
            t = (Tag)ct.getValue().get("UUIDMost");
            if (t instanceof LongTag) {
                atr.uuidMost = (Long)t.getValue();
            } else if (t instanceof IntTag) {
                atr.uuidMost = ((Integer)t.getValue()).intValue();
            }
            t = (Tag)ct.getValue().get("UUIDLeast");
            if (t instanceof LongTag) {
                atr.uuidLeast = (Long)t.getValue();
            } else if (t instanceof IntTag) {
                atr.uuidLeast = ((Integer)t.getValue()).intValue();
            }
            attrs.add(atr);
        }
        return attrs;
    }

    public static long uuidChoice(ItemStack its) {
        String mat = CoreUtilities.toLowerCase(its.getType().name());
        if (mat.contains("boots")) {
            return 1000L;
        }
        if (mat.contains("legging")) {
            return 100000L;
        }
        if (mat.contains("helmet")) {
            return 10000000L;
        }
        if (mat.contains("chestp")) {
            return 1000000000L;
        }
        return 1L;
    }

    public static ItemStack addAttribute(ItemStack itemStack, String attr, String slot, int op, double amt) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        ArrayList<CompoundTag> attribs = new ArrayList<CompoundTag>();
        if (compoundTag.getValue().containsKey(KEY_ATTRIBUTES)) {
            List temp = (List)((Tag)compoundTag.getValue().get(KEY_ATTRIBUTES)).getValue();
            for (Tag tag : temp) {
                attribs.add((CompoundTag)tag);
            }
        }
        HashMap<String, Tag> tmap = new HashMap<String, Tag>();
        tmap.put("AttributeName", new StringTag(attr));
        tmap.put("Name", new StringTag(attr));
        tmap.put("Slot", new StringTag(slot));
        tmap.put("Operation", new IntTag(op));
        tmap.put("Amount", new DoubleTag(amt));
        long uuidhelp = CustomNBT.uuidChoice(itemStack);
        tmap.put("UUIDMost", new LongTag(uuidhelp + 88512L + (long)attribs.size()));
        tmap.put("UUIDLeast", new LongTag(uuidhelp * 2L + 1250025L + (long)attribs.size()));
        CompoundTag ct = NMSHandler.getInstance().createCompoundTag(tmap);
        attribs.add(ct);
        ListTag lt = new ListTag(CompoundTag.class, attribs);
        compoundTag = compoundTag.createBuilder().put(KEY_ATTRIBUTES, lt).build();
        return NMSHandler.getInstance().getItemHelper().setNbtData(itemStack, compoundTag);
    }

    public static ItemStack addCustomNBT(ItemStack itemStack, String key, String value, String basekey) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        CompoundTag denizenTag = compoundTag.getValue().containsKey(basekey) ? (CompoundTag)compoundTag.getValue().get(basekey) : NMSHandler.getInstance().createCompoundTag(new HashMap<String, Tag>());
        denizenTag = denizenTag.createBuilder().putString(CoreUtilities.toLowerCase(key), value).build();
        compoundTag = compoundTag.createBuilder().put(basekey, denizenTag).build();
        return NMSHandler.getInstance().getItemHelper().setNbtData(itemStack, compoundTag);
    }

    public static ItemStack clearAttributes(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        compoundTag = compoundTag.createBuilder().remove(KEY_ATTRIBUTES).build();
        return NMSHandler.getInstance().getItemHelper().setNbtData(itemStack, compoundTag);
    }

    public static ItemStack removeCustomNBT(ItemStack itemStack, String key, String basekey) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        if (!compoundTag.getValue().containsKey(basekey)) {
            return itemStack;
        }
        CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
        denizenTag = denizenTag.createBuilder().remove(CoreUtilities.toLowerCase(key)).build();
        compoundTag = compoundTag.createBuilder().put(basekey, denizenTag).build();
        return NMSHandler.getInstance().getItemHelper().setNbtData(itemStack, compoundTag);
    }

    public static boolean hasCustomNBT(ItemStack itemStack, String key, String basekey) {
        if (itemStack == null) {
            return false;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        if (!compoundTag.getValue().containsKey(basekey)) {
            return false;
        }
        CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
        return denizenTag.getValue().containsKey(CoreUtilities.toLowerCase(key));
    }

    public static String getCustomNBT(ItemStack itemStack, String key, String basekey) {
        if (itemStack == null || key == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        if (compoundTag.getValue().containsKey(basekey)) {
            CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
            return denizenTag.getString(CoreUtilities.toLowerCase(key));
        }
        return null;
    }

    public static List<String> listNBT(ItemStack itemStack, String basekey) {
        ArrayList<String> nbt = new ArrayList<String>();
        if (itemStack == null) {
            return nbt;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(itemStack);
        if (compoundTag.getValue().containsKey(basekey)) {
            CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
            nbt.addAll(denizenTag.getValue().keySet());
        }
        return nbt;
    }

    public static Entity addCustomNBT(Entity entity, String key, String value) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        compoundTag = compoundTag.createBuilder().putString(key, value).build();
        NMSHandler.getInstance().getEntityHelper().setNbtData(entity, compoundTag);
        return entity;
    }

    public static Entity removeCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        compoundTag = compoundTag.createBuilder().remove(key).build();
        NMSHandler.getInstance().getEntityHelper().setNbtData(entity, compoundTag);
        return entity;
    }

    public static boolean hasCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return false;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        return compoundTag.getValue().containsKey(key);
    }

    public static String getCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        return compoundTag.getString(key);
    }

    public static class AttributeReturn {
        public String attr;
        public String slot;
        public int op;
        public double amt;
        public long uuidMost;
        public long uuidLeast;
    }
}

