/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class PlayerClicksBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerClicksBlockScriptEvent instance = this;
    PlayerInteractEvent event;
    dItem item;
    dLocation location;
    Element click_type;
    Element hand;
    dLocation relative;
    private static final List<String> matchHelpList = Arrays.asList("at", "entity", "npc", "player", "vehicle", "projectile", "hanging");
    private static final List<String> withHelpList = Arrays.asList("with", "using", "in");
    public boolean wasCancellationAltered;

    private boolean couldMatchIn(String lower) {
        String next;
        int index = CoreUtilities.split(lower, ' ').indexOf("in");
        if (index == -1) {
            return true;
        }
        String in = CoreUtilities.getXthArg(index + 1, lower);
        if (dInventory.matches(in) || in.equalsIgnoreCase("inventory")) {
            return false;
        }
        return !in.equalsIgnoreCase("notable") || (next = CoreUtilities.getXthArg(index + 2, lower)).equalsIgnoreCase("cuboid") || next.equalsIgnoreCase("ellipsoid");
    }

    private boolean runUsingCheck(ScriptContainer scriptContainer, String s, String lower) {
        String using;
        int index = CoreUtilities.split(lower, ' ').indexOf("using");
        String string = using = index >= 0 ? CoreUtilities.getXthArg(index + 1, lower) : "hand";
        if (!(using.equals("hand") || using.equals("off_hand") || using.equals("either_hand"))) {
            dB.echoError("Invalid USING hand in " + this.getName() + " for '" + s + "' in " + scriptContainer.getName());
            return false;
        }
        return using.equals("either_hand") || using.equalsIgnoreCase(this.hand.identify());
    }

    @Override
    public boolean runWithCheck(ScriptContainer scriptContainer, String s, String lower, dItem held) {
        int index = CoreUtilities.split(lower, ' ').indexOf("with");
        if (index == -1) {
            return true;
        }
        String with = CoreUtilities.getXthArg(index + 1, lower);
        if (with != null) {
            if (with.equals("item")) {
                return true;
            }
            dItem it = dItem.valueOf(with);
            if (it == null) {
                dB.echoError("Invalid WITH item in " + this.getName() + " for '" + s + "' in " + scriptContainer.getName());
                return false;
            }
            if (held == null || !this.tryItem(held, with)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return (lower.startsWith("player clicks") || lower.startsWith("player left clicks") || lower.startsWith("player right clicks") && !matchHelpList.contains(CoreUtilities.getXthArg(3, lower)) && !dEntity.matches(CoreUtilities.getXthArg(3, lower))) && this.couldMatchIn(lower);
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        int index = CoreUtilities.split(lower, ' ').indexOf("clicks") + 1;
        if (index == 3 && !this.click_type.identify().startsWith(CoreUtilities.getXthArg(1, lower).toUpperCase())) {
            return false;
        }
        dMaterial material = this.event.hasBlock() ? dMaterial.getMaterialFrom(this.event.getClickedBlock().getType(), this.event.getClickedBlock().getData()) : null;
        String mat = CoreUtilities.getXthArg(index, lower);
        if (mat.length() > 0 && !withHelpList.contains(mat) && !this.tryMaterial(material, mat)) {
            return false;
        }
        if (!this.runWithCheck(scriptContainer, s, lower, new dItem(this.event.getItem()))) {
            return false;
        }
        if (!this.runUsingCheck(scriptContainer, s, lower)) {
            return false;
        }
        return !(this.location != null ? !this.runInCheck(scriptContainer, s, lower, this.location) : !this.runInCheck(scriptContainer, s, lower, this.event.getPlayer().getLocation()));
    }

    @Override
    public String getName() {
        return "PlayerClicksBlock";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        this.wasCancellationAltered = true;
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.getPlayerFrom((Entity)this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("click_type")) {
            return this.click_type;
        }
        if (name.equals("hand")) {
            return this.hand;
        }
        if (name.equals("relative")) {
            return this.relative;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerClicksBlock(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        this.hand = new Element(NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) ? event.getHand().name() : "HAND");
        this.item = new dItem(event.getItem());
        this.location = event.hasBlock() ? new dLocation(event.getClickedBlock().getLocation()) : null;
        this.relative = event.hasBlock() ? new dLocation(event.getClickedBlock().getRelative(event.getBlockFace()).getLocation()) : null;
        this.click_type = new Element(event.getAction().name());
        this.cancelled = event.isCancelled() && event.useItemInHand() == Event.Result.DENY;
        this.event = event;
        this.wasCancellationAltered = false;
        this.fire();
        if (this.wasCancellationAltered) {
            event.setCancelled(this.cancelled);
        }
    }
}

